/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.onchange.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class OnChangeFunctions {
    private static final Map<String, Method> ON_CHANGE_FUNCTOINS = new LinkedHashMap<String, Method>();

    private static void setErrorMessages() {
        try {
            Properties properties = new Properties();
            properties.load(OnChangeFunctions.class.getResourceAsStream("/resources/config/OnChangeFunctions.properties"));
            Set<Object> keys = properties.keySet();
            for (Object obj : keys) {
                String key = (String)obj;
                if ("onchange.implementor.class".equals(key)) continue;
                String onChangeMethodName = properties.getProperty(key);
                try {
                    Class<?> onChangeClass = Class.forName(properties.getProperty("onchange.implementor.class"));
                    Method method = onChangeClass.getMethod(onChangeMethodName, ValidationAware.class);
                    ON_CHANGE_FUNCTOINS.put(key, method);
                }
                catch (Throwable ex) {
                    LoggerManager.LOG.info("Error While executeOnChangeMethod for onChangeMethodName ... " + onChangeMethodName);
                    LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                }
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static Method getOnChange(String key) {
        if (ON_CHANGE_FUNCTOINS.containsKey(key)) {
            return ON_CHANGE_FUNCTOINS.get(key);
        }
        return null;
    }

    static {
        OnChangeFunctions.setErrorMessages();
    }
}

