/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.jfx.builders;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javafx.scene.Node;

public abstract class NodeBuilder<B extends NodeBuilder<B>> {
    protected Set<String> propertySet = new HashSet<String>();
    private Collection<? extends String> styleClass;
    private boolean mouseTransparent;

    public void applyTo(Node paramNode) {
        Iterator<String> iterator = this.propertySet.iterator();
        while (iterator.hasNext()) {
            String property;
            switch (property = iterator.next()) {
                case "styleClass": {
                    paramNode.getStyleClass().addAll(this.styleClass);
                    break;
                }
                case "mouseTransparent": {
                    paramNode.setMouseTransparent(this.mouseTransparent);
                }
            }
        }
    }

    public B styleClass(String ... paramArrayOfString) {
        return this.styleClass(Arrays.asList(paramArrayOfString));
    }

    public B styleClass(Collection<? extends String> paramCollection) {
        this.styleClass = paramCollection;
        this.addProperty("styleClass");
        return (B)this;
    }

    public B mouseTransparent(boolean paramBoolean) {
        this.mouseTransparent = paramBoolean;
        this.addProperty("mouseTransparent");
        return (B)this;
    }

    protected void addProperty(String property) {
        this.propertySet.add(property);
    }
}

