/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dsc.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.util.Base64Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

public class SignerUtil {
    private String certChain = "";
    private String signature = "";
    private PrivateKey mPrivateKey;
    private Certificate[] mCertificationChain;
    private KeyStore userKeyStore;
    private X509Certificate x509Certificate;

    public void signFile(InputStream fileName, InputStream keyStoreFile, String password) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(fileName);
        byte[] dataByte = new byte[bis.available()];
        bis.read(dataByte);
        bis.close();
        this.userKeyStore = this.loadKeyStoreFromPFXFile(keyStoreFile, password);
        this.setPrivateKeyAndCertChain(this.userKeyStore, password);
        if (this.mPrivateKey == null) {
            String errorMessage = "Can not find the private key in the specified file .";
            throw new Exception("Can not find the private key in the specified file .");
        }
        if (this.mCertificationChain == null) {
            String errorMessage = "Can not find neither certificate nor certification chain in the file .";
            throw new Exception("Can not find neither certificate nor certification chain in the file .");
        }
        this.certChain = this.encodeX509CertChainToBase64(this.mCertificationChain);
        this.x509Certificate = this.getX509Certificate(this.certChain);
        byte[] digitalSignature = this.signDocument(dataByte, this.mPrivateKey, this.x509Certificate.getSigAlgName());
        this.signature = Base64Utils.base64Encode(digitalSignature);
    }

    public String initSignature(InputStream fileName) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(fileName);
        byte[] dataByte = new byte[bis.available()];
        bis.read(dataByte);
        bis.close();
        byte[] digitalSignature = this.signDocument(dataByte, this.mPrivateKey, this.x509Certificate.getSigAlgName());
        this.signature = Base64Utils.base64Encode(digitalSignature);
        return this.signature;
    }

    public void intCertChain(InputStream keyStoreFile, String password) throws Exception {
        this.userKeyStore = this.loadKeyStoreFromPFXFile(keyStoreFile, password);
        keyStoreFile.close();
        this.setPrivateKeyAndCertChain(this.userKeyStore, password);
        if (this.mPrivateKey == null) {
            String errorMessage = "Can not find the private key in the specified file .";
            throw new Exception("Can not find the private key in the specified file .");
        }
        if (this.mCertificationChain == null) {
            String errorMessage = "Can not find neither certificate nor certification chain in the file .";
            throw new Exception("Can not find neither certificate nor certification chain in the file .");
        }
        this.certChain = this.encodeX509CertChainToBase64(this.mCertificationChain);
        this.x509Certificate = this.getX509Certificate(this.certChain);
    }

    public void intCertChainUsbToken(KeyStore keyStore, String alias) throws Exception {
        this.userKeyStore = keyStore;
        LoggerManager.LOG.fine("intCertChainUsbToken alias :- " + alias);
        this.setPrivateKeyAndCertChainToken(this.userKeyStore, alias);
        if (this.mPrivateKey == null) {
            String errorMessage = "Can not find the private key in the specified file .";
            throw new Exception("Can not find the private key in the specified file .");
        }
        if (this.mCertificationChain == null) {
            String errorMessage = "Can not find neither certificate nor certification chain in the file .";
            throw new Exception("Can not find neither certificate nor certification chain in the file .");
        }
        this.certChain = this.encodeX509CertChainToBase64(this.mCertificationChain);
        this.x509Certificate = this.getX509Certificate(this.certChain);
    }

    private KeyStore loadKeyStoreFromPFXFile(InputStream keyStoreStream, String aKeyStorePasswd) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        char[] password = aKeyStorePasswd.toCharArray();
        keyStore.load(keyStoreStream, password);
        return keyStore;
    }

    private void setPrivateKeyAndCertChainToken(KeyStore aKeyStore, String alias) throws GeneralSecurityException {
        PrivateKey privateKey;
        Certificate[] certificationChain = aKeyStore.getCertificateChain(alias);
        this.mPrivateKey = privateKey = (PrivateKey)aKeyStore.getKey(alias, null);
        this.mCertificationChain = certificationChain;
    }

    private void setPrivateKeyAndCertChain(KeyStore aKeyStore, String aKeyPassword) throws GeneralSecurityException {
        char[] password = aKeyPassword.toCharArray();
        Enumeration<String> aliasesEnum = aKeyStore.aliases();
        if (aliasesEnum.hasMoreElements()) {
            PrivateKey privateKey;
            String alias = aliasesEnum.nextElement();
            Certificate[] certificationChain = aKeyStore.getCertificateChain(alias);
            this.mPrivateKey = privateKey = (PrivateKey)aKeyStore.getKey(alias, password);
            this.mCertificationChain = certificationChain;
        }
    }

    private String encodeX509CertChainToBase64(Certificate[] aCertificationChain) throws CertificateException {
        List<Certificate> certList = Arrays.asList(aCertificationChain);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        CertPath certPath = certFactory.generateCertPath(certList);
        byte[] certPathEncoded = certPath.getEncoded("PkiPath");
        String base64encodedCertChain = Base64Utils.base64Encode(certPathEncoded);
        return base64encodedCertChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate getX509Certificate(String strMCertChainBase64encoding) throws Exception {
        CertPath certPath = null;
        byte[] certChainEncoded = Base64Utils.base64Decode(strMCertChainBase64encoding);
        try (ByteArrayInputStream certChainStream = new ByteArrayInputStream(certChainEncoded);){
            X509Certificate mCertificate;
            X509Certificate localX509Certificate1;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certPath = cf.generateCertPath(certChainStream, "PkiPath");
            List<? extends Certificate> certsInChain = certPath.getCertificates();
            X509Certificate[] mCertChain = certsInChain.toArray(new X509Certificate[0]);
            X509Certificate x509Certificate = localX509Certificate1 = (mCertificate = mCertChain[0]);
            return x509Certificate;
        }
    }

    private byte[] signDocument(byte[] aDocument, PrivateKey aPrivateKey, String Algorithm) throws GeneralSecurityException {
        LoggerManager.LOG.info("Signing the document");
        Signature signatureAlgorithm = Signature.getInstance(Algorithm);
        signatureAlgorithm.initSign(aPrivateKey);
        signatureAlgorithm.update(aDocument);
        byte[] digitalSignature = signatureAlgorithm.sign();
        return digitalSignature;
    }

    public String getCertChain() {
        return this.certChain;
    }

    public void setCertChain(String certChain) {
        this.certChain = certChain;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

