/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dsc.util;

import com.itd.efiling.offline.common.dsc.util.DscManagementCommUtil;
import com.itd.efiling.offline.common.dsc.util.DscManagementUtil;
import com.itd.efiling.offline.common.dsc.util.DscValidationUtil;
import com.itd.efiling.offline.common.dsc.util.SignatureDtls;
import com.itd.efiling.offline.common.dsc.util.UsbTokenUtil;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class GenerateSignatureFileCtrl {
    private static SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");

    public static String pfxSignXml(File xml, File pfxFile, String dscPassword) throws Exception {
        LoggerManager.LOG.info("pfxSignXml method");
        File signatureXml = GenerateSignatureFileCtrl.getSignaturePathName(xml);
        KeyStore keyStore = DscManagementUtil.getKeyStore(pfxFile, dscPassword);
        PrivateKey senderPrivateKey = DscManagementUtil.getSenderPrivateKey(keyStore, dscPassword);
        X509Certificate senderPublicKey = DscManagementUtil.getSenderX509Cert(keyStore);
        LoggerManager.LOG.info("SignatureXml :: " + signatureXml);
        GenerateSignatureFileCtrl.generateSignature(xml, signatureXml, senderPrivateKey, senderPublicKey);
        return signatureXml.getAbsolutePath();
    }

    public static String usbSignXml(File xml, String alias, String password) throws Exception {
        LoggerManager.LOG.info("usbSignXml method");
        File signatureXml = GenerateSignatureFileCtrl.getSignaturePathName(xml);
        X509Certificate x509cert = UsbTokenUtil.getX509Certificate(alias);
        PrivateKey privateKey = UsbTokenUtil.getPrivateKey(alias, password);
        GenerateSignatureFileCtrl.generateSignature(xml, signatureXml, privateKey, x509cert);
        return signatureXml.getAbsolutePath();
    }

    private static File getSignaturePathName(File file) throws Exception {
        String signatureFileName = GenerateSignatureFileCtrl.getSignatureFileName(Form.getForm().getFormDtl().getUserID());
        File signatureFile = new File(file.getParent(), signatureFileName);
        return signatureFile;
    }

    public static String getSignatureFileName(String userID) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String signatureFileName = userID + "_" + TIMESTAMP_FORMAT.format(timestamp) + ".signature";
        LoggerManager.LOG.info("signatureFileName : " + signatureFileName);
        return signatureFileName;
    }

    public static void generateSignature(File xmlFile, File signatureFile, PrivateKey senderPrivateKey, X509Certificate senderPublicKey) throws Exception {
        GenerateSignatureFileCtrl.PanHashValidation(Form.getForm().getFormDtl().getDscPan(), senderPublicKey);
        String signature = DscManagementCommUtil.getBrowseFileSignature(xmlFile, senderPrivateKey);
        SignatureDtls signatureDtls = new SignatureDtls(signature);
        String signatureDtlsXmlStr = DscManagementCommUtil.getSignatureDtlsXmlStr(signatureDtls);
        DscManagementCommUtil.generateDscSignaturedtls(signatureDtlsXmlStr, signatureFile, senderPublicKey);
        LoggerManager.LOG.info("signature generated :: " + signatureFile);
    }

    public static void PanHashValidation(String pan, X509Certificate senderPublicKey) throws Exception {
        boolean isPanValid = DscValidationUtil.isPanHashValid(senderPublicKey, pan);
        if (!isPanValid) {
            throw new Exception("error.pan.dsc.not.matched");
        }
    }
}

