/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dsc.util;

import com.itd.efiling.offline.common.dsc.util.DscConfigUtil;
import com.itd.efiling.offline.common.dsc.util.DscValidationUtil;
import com.itd.efiling.offline.common.dsc.util.EfilingDscDtls;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.Base64Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class DscManagementUtil {
    private static String AES_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static String RSA_TRANSFORMATION = "RSA";
    private static String SECRET_KEY_ALGO = "AES";
    private static int SECRET_KEY_SIZE = 128;

    public static void generateSignature(File xmlFile, File signatureFile, PrivateKey senderPrivateKey, X509Certificate senderPublicKey) throws Exception {
        DscManagementUtil.checkPanHash(xmlFile, senderPublicKey);
        String signatureDtlsXmlStr = null;
        EfilingDscDtls efilingDscDtls = DscManagementUtil.encrypt(signatureDtlsXmlStr);
        String certChain = Base64Utils.base64Encode(senderPublicKey.getEncoded());
        efilingDscDtls.setCertChain(certChain);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EfilingDscDtls.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)efilingDscDtls, signatureFile);
        LoggerManager.LOG.info("signature generated :: " + signatureFile);
    }

    public static EfilingDscDtls encrypt(String signatureDtlsXmlStr) throws Exception {
        EfilingDscDtls efilingDscDtls = new EfilingDscDtls();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(SECRET_KEY_ALGO);
        keyGenerator.init(SECRET_KEY_SIZE);
        SecretKey secretKey = keyGenerator.generateKey();
        Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION, Security.getProvider("SunJCE"));
        cipher.init(1, secretKey);
        byte[] encryptedByte = cipher.doFinal(signatureDtlsXmlStr.getBytes());
        String signatureDtlsEncrypted = Base64Utils.base64Encode(encryptedByte);
        LoggerManager.LOG.info("Encrypted Text After Encryption: " + signatureDtlsEncrypted);
        efilingDscDtls.setSignatureDtls(signatureDtlsEncrypted);
        String encryptedKey = DscManagementUtil.wrap(secretKey);
        LoggerManager.LOG.info("encryptedKey: " + encryptedKey);
        efilingDscDtls.setEncryptedKey(encryptedKey);
        return efilingDscDtls;
    }

    public static String wrap(SecretKey secretKey) throws Exception {
        Cipher cipherWrap = Cipher.getInstance(RSA_TRANSFORMATION, Security.getProvider("SunJCE"));
        cipherWrap.init(3, DscManagementUtil.getRecieverPublicKey());
        byte[] encryptedKeyBuf = cipherWrap.wrap(secretKey);
        return Base64Utils.base64Encode(encryptedKeyBuf);
    }

    public static PublicKey getRecieverPublicKey() throws Exception {
        String pubKeyFile = DscConfigUtil.getConfigProperty("public.key");
        BufferedInputStream certfis = new BufferedInputStream(DscManagementUtil.class.getResourceAsStream(pubKeyFile));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(certfis);
        PublicKey pub = cert.getPublicKey();
        certfis.close();
        return pub;
    }

    public static KeyStore getKeyStore(File dscPath, String dscPassword) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(new FileInputStream(dscPath), dscPassword.toCharArray());
        return ks;
    }

    public static PrivateKey getSenderPrivateKey(KeyStore keyStore, String dscPassword) throws Exception {
        KeyStore.PrivateKeyEntry keyEntry = null;
        Enumeration<String> aliasesEnum = keyStore.aliases();
        if (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(dscPassword.toCharArray()));
        }
        return keyEntry.getPrivateKey();
    }

    public static X509Certificate getSenderX509Cert(KeyStore keyStore) throws Exception {
        Enumeration<String> aliasesEnum = keyStore.aliases();
        X509Certificate senderPublicKey = null;
        if (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            senderPublicKey = (X509Certificate)keyStore.getCertificate(alias);
        }
        return senderPublicKey;
    }

    private static void checkPanHash(File xmlFile, X509Certificate senderPublicKey) throws Exception {
        boolean isPanValid = DscValidationUtil.isPanHashValid(senderPublicKey, Form.getForm().getFormDtl().getDscPan());
        if (!isPanValid) {
            throw new Exception();
        }
    }
}

