/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dsc.util;

import com.itd.efiling.offline.common.dsc.util.DscConfigUtil;
import com.itd.efiling.offline.common.dsc.util.EfilingDscDtls;
import com.itd.efiling.offline.common.dsc.util.SignatureDtls;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.util.Base64Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class DscManagementCommUtil {
    private static String AES_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static String RSA_TRANSFORMATION = "RSA";
    private static String SECRET_KEY_ALGO = "AES";
    private static int SECRET_KEY_SIZE = 128;

    public static String getBrowseFileSignature(File file, PrivateKey priv) throws Exception {
        int len;
        Signature dsa = Signature.getInstance("SHA256withRSA");
        dsa.initSign(priv);
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bufin = new BufferedInputStream(fis);
        byte[] buffer = new byte[1024];
        while ((len = bufin.read(buffer)) >= 0) {
            dsa.update(buffer, 0, len);
        }
        bufin.close();
        byte[] realSig = dsa.sign();
        String signature = Base64Utils.base64Encode(realSig);
        return signature;
    }

    public static String getSignatureDtlsXmlStr(SignatureDtls signatureDtls) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SignatureDtls.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        LoggerManager.LOG.info("ExtractFormDetails.getFormDetails {}" + signatureDtls);
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter stringWriter = new StringWriter();
        jaxbMarshaller.marshal((Object)signatureDtls, (Writer)stringWriter);
        String signatureDtlsXmlStr = stringWriter.toString();
        LoggerManager.LOG.info(" signatureDtlsXmlStr :: " + signatureDtlsXmlStr);
        return signatureDtlsXmlStr;
    }

    public static void generateDscSignaturedtls(String signatureDtlsXmlStr, File signatureFile, X509Certificate senderPublicKey) throws Exception {
        EfilingDscDtls efilingDscDtls = DscManagementCommUtil.encrypt(signatureDtlsXmlStr);
        String certChain = Base64Utils.base64Encode(senderPublicKey.getEncoded());
        efilingDscDtls.setCertChain(certChain);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EfilingDscDtls.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)efilingDscDtls, signatureFile);
        LoggerManager.LOG.info("signature generated :: " + signatureFile);
    }

    public static String generateDscSignaturedtls(String signatureDtlsXmlStr, X509Certificate senderPublicKey) throws Exception {
        EfilingDscDtls efilingDscDtls = DscManagementCommUtil.encrypt(signatureDtlsXmlStr);
        String certChain = Base64Utils.base64Encode(senderPublicKey.getEncoded());
        efilingDscDtls.setCertChain(certChain);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EfilingDscDtls.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)efilingDscDtls, (Writer)stringWriter);
        String signatureFile = stringWriter.toString();
        LoggerManager.LOG.info("signature generated :: " + signatureFile);
        return signatureFile;
    }

    public static EfilingDscDtls encrypt(String signatureDtlsXmlStr) throws Exception {
        EfilingDscDtls efilingDscDtls = new EfilingDscDtls();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(SECRET_KEY_ALGO);
        keyGenerator.init(SECRET_KEY_SIZE);
        SecretKey secretKey = keyGenerator.generateKey();
        Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION, Security.getProvider("SunJCE"));
        cipher.init(1, secretKey);
        byte[] encryptedByte = cipher.doFinal(signatureDtlsXmlStr.getBytes());
        String signatureDtlsEncrypted = Base64Utils.base64Encode(encryptedByte);
        LoggerManager.LOG.info("Encrypted Text After Encryption: " + signatureDtlsEncrypted);
        efilingDscDtls.setSignatureDtls(signatureDtlsEncrypted);
        String encryptedKey = DscManagementCommUtil.wrap(secretKey);
        LoggerManager.LOG.info("encryptedKey: " + encryptedKey);
        efilingDscDtls.setEncryptedKey(encryptedKey);
        return efilingDscDtls;
    }

    public static String wrap(SecretKey secretKey) throws Exception {
        Cipher cipherWrap = Cipher.getInstance(RSA_TRANSFORMATION, Security.getProvider("SunJCE"));
        cipherWrap.init(3, DscManagementCommUtil.getRecieverPublicKey());
        byte[] encryptedKeyBuf = cipherWrap.wrap(secretKey);
        return Base64Utils.base64Encode(encryptedKeyBuf);
    }

    public static PublicKey getRecieverPublicKey() throws Exception {
        String pubKeyFile = DscConfigUtil.getConfigProperty("public.key");
        BufferedInputStream certfis = new BufferedInputStream(DscManagementCommUtil.class.getResourceAsStream(pubKeyFile));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(certfis);
        PublicKey pub = cert.getPublicKey();
        certfis.close();
        return pub;
    }

    public static KeyStore getKeyStore(File dscPath, String dscPassword) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(new FileInputStream(dscPath), dscPassword.toCharArray());
        return ks;
    }

    public static PrivateKey getSenderPrivateKey(KeyStore keyStore, String dscPassword) throws Exception {
        KeyStore.PrivateKeyEntry keyEntry = null;
        Enumeration<String> aliasesEnum = keyStore.aliases();
        if (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(dscPassword.toCharArray()));
        }
        return keyEntry.getPrivateKey();
    }

    public static X509Certificate getSenderX509Cert(KeyStore keyStore) throws Exception {
        Enumeration<String> aliasesEnum = keyStore.aliases();
        X509Certificate senderPublicKey = null;
        if (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            senderPublicKey = (X509Certificate)keyStore.getCertificate(alias);
        }
        return senderPublicKey;
    }
}

