/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dialog;

import com.itd.efiling.offline.common.dialog.MessageDialog;
import com.itd.efiling.offline.common.dialog.MessageDialogBuilder;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import javafx.application.Platform;

public class MessageDialogCtrl {
    public static void displayErrorDialog(String message) {
        MessageDialogBuilder mb = MessageDialogBuilder.error();
        mb.message(message);
        mb.forceShow(RefHolders.scene.getWindow());
    }

    public static void displayErrorDialog(String title, String message) {
        MessageDialogBuilder mb = MessageDialogBuilder.error();
        mb.title(title);
        mb.message(message);
        mb.forceShow(RefHolders.scene.getWindow());
    }

    public static void displayInfoDialog(String title, String message) {
        MessageDialogBuilder mb = MessageDialogBuilder.info();
        mb.title(title);
        mb.message(message);
        mb.forceShow(RefHolders.scene.getWindow());
    }

    public static MessageDialog.Answer getConfirmationDialog(String title, String message) {
        MessageDialogBuilder mb = MessageDialogBuilder.confirmation().buttonType(MessageDialog.ButtonType.YES_NO);
        mb.title(title);
        mb.message(message);
        return mb.forceShow(RefHolders.scene.getWindow());
    }

    public static void closeUtility() {
        LoggerManager.LOG.info("Inside  closeUtility");
        String title = "Close";
        String message = "Please ensure that the data is saved before you exit. Exit form utility?";
        MessageDialog.Answer opt = MessageDialogCtrl.getConfirmationDialog("Close", "Please ensure that the data is saved before you exit. Exit form utility?");
        if (opt.equals((Object)MessageDialog.Answer.YES_OK)) {
            Platform.exit();
        }
    }
}

