/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dialog;

import com.itd.efiling.offline.common.dialog.MessageDialog;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import java.text.MessageFormat;
import javafx.scene.image.Image;
import javafx.stage.Window;

public class MessageDialogBuilder {
    private static int monitor = 0;
    private MessageDialog dialog;

    private MessageDialogBuilder(MessageDialog.DialogType dialogType) {
        this.dialog = new MessageDialog(dialogType);
    }

    private MessageDialogBuilder(Throwable throwable) {
        this.dialog = new MessageDialog(throwable);
    }

    public static MessageDialogBuilder info() {
        return new MessageDialogBuilder(MessageDialog.DialogType.INFO);
    }

    public static MessageDialogBuilder warning() {
        return new MessageDialogBuilder(MessageDialog.DialogType.WARNING);
    }

    public static MessageDialogBuilder error() {
        return new MessageDialogBuilder(MessageDialog.DialogType.ERROR);
    }

    public static MessageDialogBuilder error(Throwable throwable) {
        return new MessageDialogBuilder(throwable);
    }

    public static MessageDialogBuilder confirmation() {
        return new MessageDialogBuilder(MessageDialog.DialogType.CONFIRM);
    }

    public MessageDialog build() {
        return this.dialog;
    }

    public MessageDialogBuilder yesOkButtonText(String text) {
        this.dialog.setYesOkButtonText(text);
        return this;
    }

    public MessageDialogBuilder noButtonText(String text) {
        this.dialog.setNoButtonText(text);
        return this;
    }

    public MessageDialogBuilder cancelButtonText(String text) {
        this.dialog.setCancelButtonText(text);
        return this;
    }

    public MessageDialogBuilder defaultAnswer(MessageDialog.Answer answer) {
        this.dialog.setDefaultAnswer(answer);
        return this;
    }

    public MessageDialogBuilder escapeAnswer(MessageDialog.Answer answer) {
        this.dialog.setEscapeAnswer(answer);
        return this;
    }

    public MessageDialogBuilder buttonType(MessageDialog.ButtonType buttonType) {
        this.dialog.setButtonType(buttonType);
        return this;
    }

    public MessageDialog.Answer show(Window owner) {
        if (monitor == 0 && !RefHolders.closing && !MessageDialog.active.booleanValue()) {
            MessageDialog.Answer ans = this.dialog.show(owner);
            return ans;
        }
        return MessageDialog.Answer.CANCEL;
    }

    public MessageDialog.Answer forceShow(Window owner) {
        monitor = 1;
        MessageDialog.Answer ans = this.dialog.show(owner);
        monitor = 0;
        return ans;
    }

    public MessageDialogBuilder title(String text) {
        this.dialog.setTitle(text);
        return this;
    }

    public MessageDialogBuilder message(String message) {
        this.dialog.setMessage(message);
        return this;
    }

    public MessageDialogBuilder message(String message, Object ... params) {
        this.dialog.setMessage(MessageFormat.format(message, params));
        return this;
    }

    public MessageDialogBuilder image(Image image) {
        this.dialog.setImage(image);
        return this;
    }
}

