/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dialog;

import com.itd.efiling.offline.common.jfx.builders.AnchorPaneBuilder;
import com.itd.efiling.offline.common.jfx.builders.HBoxBuilder;
import com.itd.efiling.offline.common.jfx.builders.ImageViewBuilder;
import com.itd.efiling.offline.common.jfx.builders.LabelBuilder;
import com.itd.efiling.offline.common.jfx.builders.TilePaneBuilder;
import com.itd.efiling.offline.common.jfx.builders.VBoxBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class MessageDialog
extends StackPane {
    public static final Integer monitor = 0;
    public static Boolean active = false;
    private static Image image;
    private final Button btnYes = new Button();
    private final Button btnNo = new Button();
    private final Button btnCancel = new Button();
    private final ObjectProperty<ButtonType> buttonType = new SimpleObjectProperty();
    private final ObjectProperty<Answer> defaultAnswer = new SimpleObjectProperty((Object)Answer.YES_OK);
    private final ObjectProperty<Answer> escapeAnswer = new SimpleObjectProperty();
    private final StringProperty yesText = new SimpleStringProperty("Ok");
    private final StringProperty noText = new SimpleStringProperty("No");
    private final StringProperty cancelText = new SimpleStringProperty("Cancel");
    protected Label lblTitle;
    protected Label lblMessage;
    protected TilePane pnlButton;
    protected ImageView imageView;
    private double dragOffsetX = 0.0;
    private double dragOffsetY = 0.0;
    private double initialWidth;
    private double initialHeight;
    private Point2D dragAnchor;
    private Stage stage;
    private Answer answer;
    private final EventHandler<ActionEvent> buttonClickHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent t) {
            Object source = t.getSource();
            if (source.equals(MessageDialog.this.btnCancel)) {
                MessageDialog.this.answer = Answer.CANCEL;
            } else if (source.equals(MessageDialog.this.btnNo)) {
                MessageDialog.this.answer = Answer.NO;
            } else {
                MessageDialog.this.answer = Answer.YES_OK;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.this.stage.hide();
                    MessageDialog.this.stage.close();
                    active = false;
                }
            });
        }
    };

    public MessageDialog(Throwable throwable) {
        this(DialogType.ERROR, throwable);
    }

    public MessageDialog(DialogType dialogType) {
        this(dialogType, null);
    }

    private MessageDialog(DialogType dialogType, Throwable throwable) {
        this.getStyleClass().addAll((Object[])new String[]{"dialog"});
        this.lblTitle = ((LabelBuilder)LabelBuilder.create().styleClass("title")).build();
        HBox pnlTitle = ((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().children(new Node[]{this.lblTitle})).styleClass("header")).build();
        pnlTitle.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                MessageDialog.this.dragOffsetX = mouseEvent.getSceneX();
                MessageDialog.this.dragOffsetY = mouseEvent.getSceneY();
            }
        });
        pnlTitle.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (MessageDialog.this.getCursor().equals(Cursor.DEFAULT)) {
                    MessageDialog.this.stage.setX(mouseEvent.getScreenX() - MessageDialog.this.dragOffsetX);
                    MessageDialog.this.stage.setY(mouseEvent.getScreenY() - MessageDialog.this.dragOffsetY);
                }
            }
        });
        this.lblMessage = LabelBuilder.create().wrapText(true).build();
        VBox pnlMessage = ((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{this.lblMessage})).styleClass("message-panel")).spacing(10.0).build();
        VBox.setVgrow((Node)this.lblMessage, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)pnlMessage, (Priority)Priority.ALWAYS);
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            TextArea text = new TextArea(sw.toString());
            text.setEditable(false);
            text.setWrapText(true);
            text.setPrefWidth(480.0);
            text.setPrefHeight(240.0);
            VBox.setVgrow((Node)text, (Priority)Priority.ALWAYS);
            pnlMessage.getChildren().add((Object)text);
        }
        this.btnCancel.setMaxWidth(Double.MAX_VALUE);
        this.btnNo.setMaxWidth(Double.MAX_VALUE);
        this.btnYes.setMaxWidth(Double.MAX_VALUE);
        this.pnlButton = ((TilePaneBuilder)TilePaneBuilder.create().styleClass("button-panel")).hgap(10.0).build();
        VBox pnlClient = ((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{pnlTitle, pnlMessage, this.pnlButton})).styleClass("dialog-root")).build();
        this.imageView = ImageViewBuilder.create().build();
        AnchorPane.setTopAnchor((Node)this.imageView, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.imageView, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)this.imageView, (Double)10.0);
        AnchorPane pnlImage = ((AnchorPaneBuilder)((AnchorPaneBuilder)AnchorPaneBuilder.create().children(new Node[]{this.imageView})).mouseTransparent(true)).build();
        this.getChildren().addAll((Object[])new Node[]{pnlClient, pnlImage});
        this.setMaxWidth(1000.0);
        this.buttonType.addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                MessageDialog.this.setDefaultButton();
                if (MessageDialog.this.buttonType.get() == ButtonType.OK) {
                    MessageDialog.this.pnlButton.setPrefColumns(1);
                } else if (MessageDialog.this.buttonType.get() == ButtonType.YES_NO) {
                    MessageDialog.this.pnlButton.setPrefColumns(2);
                } else {
                    MessageDialog.this.pnlButton.setPrefColumns(3);
                }
            }
        });
        this.buttonType.set((Object)dialogType.getDefaultButtonType());
        switch (dialogType) {
            case CONFIRM: {
                image = new Image(MessageDialog.class.getResourceAsStream("/resources/images/confirm48.png"));
                this.yesText.set((Object)"Yes");
                this.setTitle("confirmation");
                break;
            }
            case ERROR: {
                image = new Image(MessageDialog.class.getResourceAsStream("/resources/images/error48.png"));
                this.setTitle("");
                break;
            }
            case INFO: {
                image = new Image(MessageDialog.class.getResourceAsStream("/resources/images/info48.png"));
                this.setTitle("information");
                break;
            }
            case WARNING: {
                image = new Image(MessageDialog.class.getResourceAsStream("/resources/images/warning48.png"));
                this.setTitle("warning");
            }
        }
        this.imageView.setImage(image);
        this.initButtonBehaviors();
        this.initResizeRoutine();
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
    }

    public void setTitle(String title) {
        this.lblTitle.setText(title);
    }

    public String getTitle() {
        return this.lblTitle.getText();
    }

    public void setMessage(String message) {
        this.lblMessage.setText(message);
    }

    public String getMessage() {
        return this.lblMessage.getText();
    }

    private void initButtonBehaviors() {
        this.btnCancel.textProperty().bind((ObservableValue)this.cancelText);
        this.btnNo.textProperty().bind((ObservableValue)this.noText);
        this.btnYes.textProperty().bind((ObservableValue)this.yesText);
        this.btnCancel.setMinWidth(Double.NEGATIVE_INFINITY);
        this.btnNo.setMinWidth(Double.NEGATIVE_INFINITY);
        this.btnYes.setMinWidth(Double.NEGATIVE_INFINITY);
        this.btnCancel.cancelButtonProperty().bind((ObservableValue)this.escapeAnswer.isEqualTo((Object)Answer.CANCEL));
        this.btnNo.cancelButtonProperty().bind((ObservableValue)this.escapeAnswer.isEqualTo((Object)Answer.NO));
        this.btnYes.cancelButtonProperty().bind((ObservableValue)this.escapeAnswer.isEqualTo((Object)Answer.YES_OK));
        this.btnCancel.defaultButtonProperty().bind((ObservableValue)this.defaultAnswer.isEqualTo((Object)Answer.CANCEL));
        this.btnNo.defaultButtonProperty().bind((ObservableValue)this.defaultAnswer.isEqualTo((Object)Answer.NO));
        this.btnYes.defaultButtonProperty().bind((ObservableValue)this.defaultAnswer.isEqualTo((Object)Answer.YES_OK));
        this.btnCancel.setOnAction(this.buttonClickHandler);
        this.btnNo.setOnAction(this.buttonClickHandler);
        this.btnYes.setOnAction(this.buttonClickHandler);
    }

    private void initResizeRoutine() {
        this.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                double dragAreaX = MessageDialog.this.stage.getWidth() - 5.0;
                double dragAreaY = MessageDialog.this.stage.getHeight() - 5.0;
                if (mouseEvent.getSceneX() > dragAreaX && mouseEvent.getSceneY() > dragAreaY) {
                    MessageDialog.this.setCursor(Cursor.SE_RESIZE);
                } else if (mouseEvent.getSceneX() > dragAreaX) {
                    MessageDialog.this.setCursor(Cursor.E_RESIZE);
                } else if (mouseEvent.getSceneY() > dragAreaY) {
                    MessageDialog.this.setCursor(Cursor.S_RESIZE);
                } else {
                    MessageDialog.this.setCursor(Cursor.DEFAULT);
                }
            }
        });
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                MessageDialog.this.initialWidth = MessageDialog.this.stage.getWidth();
                MessageDialog.this.initialHeight = MessageDialog.this.stage.getHeight();
                MessageDialog.this.dragAnchor = new Point2D(t.getSceneX(), t.getSceneY());
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (MessageDialog.this.getCursor().equals(Cursor.DEFAULT)) {
                    return;
                }
                double locX = t.getSceneX();
                double locY = t.getSceneY();
                if (MessageDialog.this.getCursor().equals(Cursor.S_RESIZE) || MessageDialog.this.getCursor().equals(Cursor.SE_RESIZE)) {
                    MessageDialog.this.stage.setHeight(MessageDialog.this.initialHeight + locY - MessageDialog.this.dragAnchor.getY());
                }
                if (MessageDialog.this.getCursor().equals(Cursor.E_RESIZE) || MessageDialog.this.getCursor().equals(Cursor.SE_RESIZE)) {
                    MessageDialog.this.stage.setWidth(MessageDialog.this.initialWidth + locX - MessageDialog.this.dragAnchor.getX());
                }
            }
        });
    }

    public void setButtonType(ButtonType type) {
        this.buttonType.set((Object)type);
    }

    private void setDefaultButton() {
        this.pnlButton.getChildren().clear();
        switch ((ButtonType)((Object)this.buttonType.get())) {
            case OK: {
                this.pnlButton.getChildren().add((Object)this.btnYes);
                this.defaultAnswer.set((Object)Answer.YES_OK);
                this.escapeAnswer.set((Object)Answer.YES_OK);
                break;
            }
            case YES_NO: {
                this.pnlButton.getChildren().add((Object)this.btnYes);
                this.pnlButton.getChildren().add((Object)this.btnNo);
                this.defaultAnswer.set((Object)Answer.YES_OK);
                this.escapeAnswer.set((Object)Answer.NO);
                break;
            }
            case YES_NO_CANCEL: {
                this.pnlButton.getChildren().add((Object)this.btnYes);
                this.pnlButton.getChildren().add((Object)this.btnNo);
                this.pnlButton.getChildren().add((Object)this.btnCancel);
                this.defaultAnswer.set((Object)Answer.YES_OK);
                this.escapeAnswer.set((Object)Answer.CANCEL);
            }
        }
    }

    public void setYesOkButtonText(String text) {
        this.yesText.set((Object)text);
    }

    public void setNoButtonText(String text) {
        this.noText.set((Object)text);
    }

    public void setCancelButtonText(String text) {
        this.cancelText.set((Object)text);
    }

    public void setDefaultAnswer(Answer answer) {
        this.defaultAnswer.set((Object)answer);
    }

    public void setEscapeAnswer(Answer answer) {
        this.escapeAnswer.set((Object)answer);
        this.btnCancel.setOnAction(this.buttonClickHandler);
    }

    public Answer show(Window owner) {
        active = true;
        this.stage = new Stage(StageStyle.TRANSPARENT);
        this.stage.setScene(new Scene((Parent)this));
        if (owner != null) {
            this.stage.initOwner(owner);
        }
        this.stage.initModality(Modality.WINDOW_MODAL);
        this.stage.getScene().getStylesheets().add((Object)"resources/css/dialog.css");
        this.stage.getScene().setFill((Paint)Color.TRANSPARENT);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Button btn = MessageDialog.this.btnCancel.isDefaultButton() ? MessageDialog.this.btnCancel : (MessageDialog.this.btnNo.isDefaultButton() ? MessageDialog.this.btnNo : MessageDialog.this.btnYes);
                btn.requestFocus();
            }
        });
        this.stage.showAndWait();
        return this.answer;
    }

    public static enum DialogType {
        CONFIRM(ButtonType.YES_NO),
        ERROR(ButtonType.OK),
        INFO(ButtonType.OK),
        WARNING(ButtonType.OK);

        private final ButtonType type;

        private DialogType(ButtonType type) {
            this.type = type;
        }

        public ButtonType getDefaultButtonType() {
            return this.type;
        }
    }

    public static enum ButtonType {
        OK,
        YES_NO,
        YES_NO_CANCEL;

    }

    public static enum Answer {
        YES_OK,
        NO,
        CANCEL;

    }
}

