/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.csv.jaxb.beans;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.csv.jaxb.beans.ImportCsvDtl;
import com.itd.efiling.offline.common.csv.jaxb.beans.ImportCsvDtlsRoot;
import com.itd.efiling.offline.common.csv.jaxb.beans.ImportCsvMapping;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ImportCsvCacher {
    private static final Map<String, ImportCsvDtl> IMPORT_CSV_DTL_MAPPINGS = new LinkedHashMap<String, ImportCsvDtl>();

    private ImportCsvCacher() {
    }

    private static void load() {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ImportCsvDtlsRoot.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            InputStream is = ImportCsvCacher.class.getResourceAsStream(Configs.getConfigProperty("import.csv.config.file"));
            ImportCsvDtlsRoot importCsvDtlsRoot = (ImportCsvDtlsRoot)unmarshaller.unmarshal(is);
            for (ImportCsvDtl importCsvDtl : importCsvDtlsRoot.getImportCsvDtls()) {
                String name = importCsvDtl.getName();
                IMPORT_CSV_DTL_MAPPINGS.put(name, importCsvDtl);
            }
            is.close();
            LoggerManager.LOG.info("IMPORT_CSV_DTL_MAPPINGS " + IMPORT_CSV_DTL_MAPPINGS.size());
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static List<ImportCsvMapping> getImportCsvMappings(String key) {
        return IMPORT_CSV_DTL_MAPPINGS.get(key).getImportCsvMappings();
    }

    public static String getUniqueIdentifier(String key) {
        return IMPORT_CSV_DTL_MAPPINGS.get(key).getUniqueIdentifier();
    }

    static {
        ImportCsvCacher.load();
    }
}

