/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.CalendarView;
import com.itd.efiling.offline.common.calendar.DatePane;
import java.text.DateFormatSymbols;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

final class YearView
extends DatePane {
    private static final String CSS_CALENDAR_YEAR_VIEW = "calendar-year-view";
    private static final String CSS_CALENDAR_MONTH_BUTTON = "calendar-month-button";

    public YearView(CalendarView calendarView) {
        super(calendarView);
        this.getStyleClass().add((Object)CSS_CALENDAR_YEAR_VIEW);
        calendarView.localeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                YearView.this.updateContent();
            }
        });
    }

    @Override
    protected void buildContent() {
        int numberOfMonths = this.calendarView.getCalendar().getMaximum(2) + 1;
        int numberOfColumns = 3;
        for (int i = 0; i < numberOfMonths; ++i) {
            final int j = i;
            Button button = new Button();
            button.getStyleClass().add((Object)CSS_CALENDAR_MONTH_BUTTON);
            button.setMaxWidth(Double.MAX_VALUE);
            button.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (YearView.this.calendarView.currentlyViewing.get() == 1) {
                        YearView.this.calendarView.getCalendar().set(2, j);
                        YearView.this.calendarView.currentlyViewing.set(2);
                        YearView.this.calendarView.calendarDate.set((Object)YearView.this.calendarView.getCalendar().getTime());
                    }
                }
            });
            int rowIndex = i % numberOfColumns;
            int colIndex = (i - rowIndex) / numberOfColumns;
            this.add((Node)button, rowIndex, colIndex);
        }
    }

    @Override
    protected void updateContent() {
        DateFormatSymbols symbols = new DateFormatSymbols((Locale)this.calendarView.localeProperty().get());
        String[] monthNames = symbols.getShortMonths();
        for (int i = 1; i < monthNames.length; ++i) {
            Button button = (Button)this.getChildren().get(i - 1);
            button.setText(monthNames[i - 1]);
        }
        this.title.set((Object)this.getDateFormat("yyyy").format(this.calendarView.getCalendar().getTime()));
    }
}

