/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.AnimatedStackPane;
import com.itd.efiling.offline.common.calendar.CalendarView;
import com.itd.efiling.offline.common.calendar.DecadesView;
import com.itd.efiling.offline.common.calendar.MonthView;
import com.itd.efiling.offline.common.calendar.YearView;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

final class MainStackPane
extends StackPane {
    private AnimatedStackPane monthView;
    private AnimatedStackPane yearView;
    private AnimatedStackPane decadesView;
    private CalendarView calendarView;

    public MainStackPane(final CalendarView calendarView) {
        this.calendarView = calendarView;
        this.monthView = new AnimatedStackPane(new MonthView(calendarView), new MonthView(calendarView));
        this.yearView = new AnimatedStackPane(new YearView(calendarView), new YearView(calendarView));
        this.decadesView = new AnimatedStackPane(new DecadesView(calendarView), new DecadesView(calendarView));
        this.getChildren().addAll((Object[])new Node[]{this.monthView, this.yearView, this.decadesView});
        calendarView.title.bind((ObservableValue)this.monthView.actualPane.titleProperty());
        this.yearView.setVisible(false);
        this.decadesView.setVisible(false);
        calendarView.currentlyViewing.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldNumber, Number newNumber) {
                calendarView.title.unbind();
                switch (oldNumber.intValue()) {
                    case 2: {
                        switch (newNumber.intValue()) {
                            case 1: {
                                calendarView.title.bind((ObservableValue)((MainStackPane)MainStackPane.this).yearView.actualPane.titleProperty());
                                MainStackPane.this.showOrHide(MainStackPane.this.yearView, true);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (newNumber.intValue()) {
                            case 2: {
                                MainStackPane.this.showOrHide(MainStackPane.this.yearView, false);
                                MainStackPane.this.monthView.requestFocus();
                                calendarView.title.bind((ObservableValue)((MainStackPane)MainStackPane.this).monthView.actualPane.titleProperty());
                                break;
                            }
                            case 0: {
                                MainStackPane.this.showOrHide(MainStackPane.this.decadesView, true);
                                calendarView.title.bind((ObservableValue)((MainStackPane)MainStackPane.this).decadesView.actualPane.titleProperty());
                            }
                        }
                        break;
                    }
                    case 0: {
                        switch (newNumber.intValue()) {
                            case 1: {
                                MainStackPane.this.showOrHide(MainStackPane.this.decadesView, false);
                                calendarView.title.bind((ObservableValue)((MainStackPane)MainStackPane.this).yearView.actualPane.titleProperty());
                            }
                        }
                    }
                }
            }
        });
    }

    private void showOrHide(final AnimatedStackPane stackPane, final boolean show) {
        stackPane.setVisible(true);
        this.calendarView.ongoingTransitions.set(this.calendarView.ongoingTransitions.get() + 1);
        TranslateTransition translateTransition = new TranslateTransition(Duration.seconds((double)0.5), (Node)stackPane);
        FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)0.5), (Node)stackPane);
        this.setClip((Node)new Rectangle(stackPane.getBoundsInLocal().getWidth(), stackPane.getBoundsInLocal().getHeight()));
        if (show) {
            translateTransition.setFromY(-this.getBoundsInLocal().getHeight());
            translateTransition.setToY(0.0);
            fadeTransition.setToValue(1.0);
            fadeTransition.setFromValue(0.0);
        } else {
            translateTransition.setToY(-this.getBoundsInLocal().getHeight());
            translateTransition.setFromY(0.0);
            fadeTransition.setToValue(0.0);
            fadeTransition.setFromValue(1.0);
        }
        ParallelTransition parallelTransition = new ParallelTransition();
        parallelTransition.getChildren().add((Object)translateTransition);
        parallelTransition.getChildren().add((Object)fadeTransition);
        parallelTransition.play();
        parallelTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (!show) {
                    ((MainStackPane)MainStackPane.this).calendarView.mainNavigationPane.titleButton.requestFocus();
                    stackPane.setVisible(false);
                }
                ((MainStackPane)MainStackPane.this).calendarView.ongoingTransitions.set(((MainStackPane)MainStackPane.this).calendarView.ongoingTransitions.get() - 1);
                if (((MainStackPane)MainStackPane.this).calendarView.ongoingTransitions.get() == 0) {
                    MainStackPane.this.setClip(null);
                }
            }
        });
    }
}

