/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.CalendarView;
import com.itd.efiling.offline.javafx.ui.components.ValDateField;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Popup;

public class DatePicker
extends HBox {
    private Timer timer;
    private CalendarView calendarView;
    protected ValDateField textField;
    private final BooleanProperty invalid = new SimpleBooleanProperty();
    private final ObjectProperty<Locale> locale = new SimpleObjectProperty();
    private final ObjectProperty<Date> selectedDate = new SimpleObjectProperty();
    private final ObjectProperty<DateFormat> dateFormat = new SimpleObjectProperty((Object)new SimpleDateFormat("dd/MM/yyyy"));
    private final StringProperty promptText = new SimpleStringProperty();
    private Popup popup;

    public DatePicker() {
        this(Locale.getDefault());
    }

    public DatePicker(Locale locale) {
        this.calendarView = new CalendarView(locale);
        this.textField = new ValDateField();
        this.locale.set((Object)locale);
        this.calendarView.setEffect((Effect)new DropShadow());
        this.calendarView.localeProperty().bind(this.localeProperty());
        this.calendarView.currentDateProperty().bind(this.selectedDateProperty());
        this.calendarView.selectedDateProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                DatePicker.this.selectedDate.set(DatePicker.this.calendarView.selectedDateProperty().get());
                DatePicker.this.hidePopup();
            }
        });
        this.textField.promptTextProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                if (DatePicker.this.promptTextProperty().get() != null) {
                    return (String)DatePicker.this.promptTextProperty().get();
                }
                DateFormat dateFormat = DatePicker.this.getActualDateFormat();
                if (dateFormat instanceof SimpleDateFormat) {
                    return ((SimpleDateFormat)dateFormat).toPattern();
                }
                return "";
            }
        });
        this.textField.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (!DatePicker.this.textField.focusedProperty().get()) {
                    if (!DatePicker.this.textField.getText().equals("")) {
                        DatePicker.this.tryParse(true);
                    }
                } else {
                    DatePicker.this.showPopup();
                }
            }
        });
        this.selectedDateProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                DatePicker.this.updateTextField();
                DatePicker.this.invalid.set(false);
            }
        });
        this.localeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                DatePicker.this.updateTextField();
            }
        });
        this.textField.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.DOWN) {
                    DatePicker.this.showPopup();
                }
            }
        });
        Button button = new Button(">");
        button.setFocusTraversable(false);
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                DatePicker.this.showPopup();
            }
        });
        this.getChildren().add((Object)this.textField);
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
        }
    }

    private void tryParse(boolean setDateToNullOnException) {
        block4: {
            if (this.timer != null) {
                this.timer.cancel();
            }
            try {
                DateFormat dateFormat = this.getActualDateFormat();
                Date parsedDate = dateFormat.parse(this.textField.getText());
                parsedDate = dateFormat.parse(dateFormat.format(parsedDate));
                if (this.selectedDate.get() == null || this.selectedDate.get() != null && parsedDate.getTime() != ((Date)this.selectedDate.get()).getTime()) {
                    this.selectedDate.set((Object)parsedDate);
                }
                this.invalid.set(false);
                this.updateTextField();
            }
            catch (ParseException e) {
                this.invalid.set(true);
                if (!setDateToNullOnException) break block4;
                this.selectedDate.set(null);
            }
        }
    }

    private void updateTextField() {
        if (this.selectedDateProperty().get() != null) {
            String date = this.getActualDateFormat().format((Date)this.selectedDateProperty().get());
            if (!this.textField.getText().equals(date)) {
                this.textField.setText(date);
            }
        } else {
            this.textField.setText("");
        }
    }

    private DateFormat getActualDateFormat() {
        if (this.dateFormat.get() != null) {
            return (DateFormat)this.dateFormat.get();
        }
        DateFormat format = DateFormat.getDateInstance(3, (Locale)this.locale.get());
        format.setCalendar(this.calendarView.getCalendar());
        format.setLenient(false);
        return format;
    }

    public CalendarView getCalendarView() {
        return this.calendarView;
    }

    public ReadOnlyBooleanProperty invalidProperty() {
        return this.invalid;
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale.set((Object)locale);
    }

    public Locale getLocale() {
        return (Locale)this.locale.get();
    }

    public ObjectProperty<Date> selectedDateProperty() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date date) {
        this.selectedDate.set((Object)date);
        if (date == null) {
            this.textField.setText("");
        }
    }

    public Date getSelectedDate() {
        return (Date)this.selectedDate.get();
    }

    protected ObjectProperty<DateFormat> dateFormatProperty() {
        return this.dateFormat;
    }

    protected void setDateFormat(DateFormat dateFormat) {
        this.dateFormat.set((Object)dateFormat);
    }

    protected DateFormat getDateFormat() {
        return (DateFormat)this.dateFormat.get();
    }

    public StringProperty promptTextProperty() {
        return this.promptText;
    }

    public void setPromptText(String promptText) {
        this.promptText.set((Object)promptText);
    }

    public String getPromptText() {
        return (String)this.promptText.get();
    }

    private void showPopup() {
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setAutoHide(true);
            this.popup.setHideOnEscape(true);
            this.popup.setAutoFix(true);
            this.popup.getContent().add((Object)this.calendarView);
        }
        Bounds calendarBounds = this.calendarView.getBoundsInLocal();
        Bounds bounds = this.localToScene(this.getBoundsInLocal());
        double posX = calendarBounds.getMinX() + bounds.getMinX() + this.getScene().getX() + this.getScene().getWindow().getX();
        double posY = calendarBounds.getMinY() + bounds.getHeight() + bounds.getMinY() + this.getScene().getY() + this.getScene().getWindow().getY();
        this.popup.show((Node)this, posX, posY);
    }
}

