/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.CalendarView;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.layout.GridPane;

abstract class DatePane
extends GridPane {
    protected CalendarView calendarView;
    protected StringProperty title = new SimpleStringProperty();

    protected DatePane(CalendarView calendarView) {
        this.calendarView = calendarView;
        calendarView.calendarDate.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                DatePane.this.updateContent();
            }
        });
        calendarView.calendarProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                DatePane.this.getChildren().clear();
                DatePane.this.buildContent();
                DatePane.this.updateContent();
            }
        });
        this.buildContent();
        this.updateContent();
    }

    protected void setDate(Date date) {
        this.calendarView.getCalendar().setTime(date);
        this.updateContent();
        this.calendarView.getCalendar().setTime((Date)this.calendarView.calendarDate.get());
    }

    protected abstract void buildContent();

    protected abstract void updateContent();

    public ReadOnlyStringProperty titleProperty() {
        return this.title;
    }

    protected DateFormat getDateFormat(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, (Locale)this.calendarView.localeProperty().get());
        dateFormat.setCalendar(this.calendarView.getCalendar());
        return dateFormat;
    }
}

