/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.cachers;

import com.itd.efiling.offline.common.codec.EncryptDecryptFileUtil;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class ConfigCacher {
    private static final Map<String, String> CONFIG_PROPERTIES = new LinkedHashMap<String, String>();

    private ConfigCacher() {
    }

    private static void load() {
        try {
            Properties properties = new Properties();
            properties.load(EncryptDecryptFileUtil.getCipherInputStream(ConfigCacher.class.getResourceAsStream("/resources/config/a.b.c.icu.prop")));
            Set<String> keys = properties.stringPropertyNames();
            for (String key : keys) {
                String value = properties.getProperty(key);
                CONFIG_PROPERTIES.put(key, value);
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static String getConfigProperty(String key) {
        if (CONFIG_PROPERTIES.containsKey(key)) {
            return CONFIG_PROPERTIES.get(key);
        }
        return key;
    }

    public static String getConfigPropertyUri(String key) {
        return new File(ConfigCacher.getConfigProperty(key)).toURI().toString();
    }

    public static InputStream getConfigPropertyAsStream(String key) {
        return ConfigCacher.class.getResourceAsStream(ConfigCacher.getConfigProperty(key));
    }

    public static int getIntConfigProperty(String key) {
        if (CONFIG_PROPERTIES.containsKey(key)) {
            return Integer.parseInt(CONFIG_PROPERTIES.get(key));
        }
        return 0;
    }

    static {
        ConfigCacher.load();
    }
}

