/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validators;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class IFSCValidator
extends ValidatorInteface {
    public static final Logger LOG = Logger.getLogger(IFSCValidator.class);
    private static Set<String> validCodes = new HashSet<String>();
    private boolean doTrim;

    private static void loadCodes() {
        try {
            GZIPInputStream gzis = new GZIPInputStream(FormConfigUtil.getIFSCURL());
            BufferedReader br = new BufferedReader(new InputStreamReader(gzis));
            String code = null;
            while ((code = br.readLine()) != null) {
                validCodes.add(code);
            }
            br.close();
            gzis.close();
        }
        catch (Exception e) {
            LOG.error("Error: ", e);
        }
    }

    @Override
    public void validate(String val, String name, Validator validator) throws ValidationException {
        if (val == null || val.length() <= 0) {
            return;
        }
        if (this.doTrim && (val = val.trim()).length() <= 0) {
            return;
        }
        if (!validCodes.contains(val)) {
            this.addFieldError(name, validator);
        }
    }

    public boolean isDoTrim() {
        return this.doTrim;
    }

    public void setDoTrim(boolean doTrim) {
        this.doTrim = doTrim;
    }

    static {
        IFSCValidator.loadCodes();
    }
}

