/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validation.main;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class ValidationUtil {
    public static int getLengthOfString(String inputString) {
        if (ValidationUtil.isStringEmpty(inputString)) {
            return 0;
        }
        return inputString.trim().length();
    }

    public static boolean isStringEmpty(String inputString) {
        boolean returnStatus = true;
        if (inputString != null) {
            char[] charArray = inputString.toCharArray();
            int charArrayLength = charArray.length;
            for (int arrayIndex = 0; charArrayLength > arrayIndex && charArrayLength > 0; ++arrayIndex) {
                if (Character.isWhitespace(charArray[arrayIndex])) continue;
                returnStatus = false;
                break;
            }
        }
        return returnStatus;
    }

    public static boolean isDateValid(String inputDate, String dateFormat) {
        boolean isDateValid = false;
        try {
            if (ValidationUtil.isStringEmpty(inputDate)) {
                isDateValid = true;
            } else {
                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
                calendar.setTime(simpleDateFormat.parse(inputDate));
                String actualDate = simpleDateFormat.format(calendar.getTime());
                if (inputDate.trim().equals(actualDate.trim())) {
                    isDateValid = true;
                }
            }
        }
        catch (ParseException parseException) {
            isDateValid = false;
        }
        return isDateValid;
    }
}

