/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.Base64Utils;
import com.tcs.efiling.form.main.CreateHash;
import com.tcs.efiling.form.main.MainController;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class VerSign {
    static final Logger LOG = Logger.getLogger(MainController.class);

    public static boolean verifySignature(String publicKeyFilename, String shaFilename, String signatureFilename) throws Exception {
        PublicKey pubKey = VerSign.getPublicKey(publicKeyFilename);
        byte[] sigToVerify = Base64Utils.base64Decode(new String(VerSign.getBytesFromInputStream(signatureFilename)));
        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initVerify(pubKey);
        String hash = CreateHash.generateHash(shaFilename);
        sig.update(hash.getBytes());
        boolean verifies = sig.verify(sigToVerify);
        LOG.info("verifies : " + verifies);
        return verifies;
    }

    public static PublicKey getPublicKey(String pubKeyFile) throws Exception {
        FileInputStream certfis = new FileInputStream(pubKeyFile);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(certfis);
        PublicKey pub = cert.getPublicKey();
        return pub;
    }

    public static byte[] getBytesFromInputStream(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        byte[] buffer = new byte[fis.available()];
        fis.read(buffer);
        fis.close();
        return buffer;
    }
}

