/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.FormUploadRequest;
import com.tcs.efiling.form.config.GetCARequest;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.config.SubmitFORMRequest;
import com.tcs.efiling.form.config.UsbTokenModel;
import com.tcs.efiling.form.config.UsbTokenUtil;
import com.tcs.efiling.form.main.CreateHash;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.GetCAUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.MainLoader;
import com.tcs.efiling.form.main.SignerUtil;
import com.tcs.efiling.form.main.WebServiceUtilSingle;
import java.io.FileInputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.stage.Stage;

public class SubmitFORMDialogController
implements Initializable {
    static final Logger LOG = Logger.getLogger(SubmitFORMDialogController.class);
    private Stage myDialogStage;
    private WebEngine itrEngine;
    public static final SimpleDateFormat DD_MM_YY_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    @FXML
    TextField userId;
    @FXML
    private TextField caPanText;
    @FXML
    private TextField asPanTextId;
    @FXML
    TextField password;
    @FXML
    TextField dob;
    @FXML
    private ComboBox caUserId;
    @FXML
    Text itr;
    @FXML
    Text asstYear;
    @FXML
    Text userPan;
    @FXML
    Text verifPan;
    @FXML
    ToggleGroup radioGroup;
    @FXML
    Button selectCerFile;
    @FXML
    Button fetchCAButton;
    @FXML
    TextField passkey;
    @FXML
    Label label1;
    @FXML
    Label lavel2;
    @FXML
    HBox radioHbox;
    @FXML
    RadioButton radioYes;
    @FXML
    RadioButton radioNo;
    @FXML
    HBox keyFileHbox;
    @FXML
    GridPane gridpane2;
    @FXML
    Text errorText;
    @FXML
    ProgressBar progress;
    @FXML
    HBox pfxHbox;
    @FXML
    HBox caUserLabelHbox;
    @FXML
    HBox radioHboxLabel;
    @FXML
    HBox keyHbox;
    @FXML
    HBox key2Hbox;
    @FXML
    HBox sec44ABHbox;
    @FXML
    HBox sec44ABcheckHbox;
    @FXML
    HBox dscTypeHbox;
    @FXML
    CheckBox sec44AB;
    @FXML
    Button submit;
    @FXML
    HBox dscTypeLabel;
    @FXML
    HBox usbtokenLabelHbox;
    @FXML
    HBox usbtokenComboHbox;
    @FXML
    HBox reasonHbox;
    @FXML
    HBox descHbox;
    @FXML
    HBox caUserComboHbox;
    @FXML
    ComboBox usbCombo;
    @FXML
    ComboBox filingTypeCombo;
    @FXML
    VBox reasonBoxId;
    @FXML
    private TextArea descId;
    @FXML
    private CheckBox reason1Type;
    @FXML
    private CheckBox reason2Type;
    @FXML
    private CheckBox reason3Type;
    @FXML
    private CheckBox reason4Type;
    @FXML
    RadioButton pfxtype;
    @FXML
    RadioButton usbToken;
    @FXML
    FlowPane mainFlowPane;
    @FXML
    Text keyFile;
    private static MainController mainController;
    String itrNameVar;
    String asstYearVar;
    String versionVar;
    String isCaFlagVar;

    public void initialize(URL url, ResourceBundle rb) {
        LOG.info("initialize submit itr starts");
        try {
            this.itrNameVar = mainController.getItrName();
            this.asstYearVar = mainController.getAsstYear();
            this.versionVar = mainController.getVersion();
            this.isCaFlagVar = mainController.getIsCaFlag();
            FormCacher.initDoc(SubmitFORMDialogController.mainController.outputFileSubmit.getAbsolutePath());
            this.asstYear.setText(this.asstYearVar);
            this.itr.setText(this.itrNameVar.substring(4));
            this.addKeyEvent();
            this.hideDscRelated();
            this.initUsbTokens();
            this.hideReasonRelated();
            this.hideFecthCA();
            this.hideYesNoDsc();
            LOG.info("initialize ends");
        }
        catch (Exception e) {
            LOG.error("initialize error ", e);
            mainController.generateErrorDialog("Error in submit,Please click submit again. ", true);
        }
    }

    private void initUsbTokens() {
        try {
            Map<String, UsbTokenModel> tokens = UsbTokenUtil.getUsbTokenData();
            for (String key : tokens.keySet()) {
                this.usbCombo.getItems().add((Object)key);
            }
            this.usbCombo.getSelectionModel().selectFirst();
        }
        catch (Exception e) {
            LOG.error("initUsbTokens error", e);
        }
    }

    private void addKeyEvent() {
        this.userId.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                try {
                    SubmitFORMDialogController.this.userId.setText(SubmitFORMDialogController.this.userId.getText().toUpperCase());
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
        this.userId.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (!t1.trim().matches("^[0-9A-Za-z]{0,10}$")) {
                    SubmitFORMDialogController.this.userId.setText(t);
                }
                if (t1 != null && t1.length() > 10) {
                    SubmitFORMDialogController.this.userId.setText(t1.substring(0, 10).toUpperCase());
                }
                if (t1.trim().matches("^[A-Za-z]{4}[0-9]{5}[a-zA-Z]{1}$")) {
                    SubmitFORMDialogController.this.dob.setDisable(true);
                    SubmitFORMDialogController.this.dob.setPromptText("");
                    SubmitFORMDialogController.this.dob.setText("");
                    WebServiceUtilSingle.submitFORMRequest.setDob(null);
                } else {
                    SubmitFORMDialogController.this.dob.setDisable(false);
                    SubmitFORMDialogController.this.dob.setPromptText("Enter DOB (DD/MM/YYYY)");
                }
            }
        });
        if (FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar)) {
            this.asPanTextId.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    try {
                        SubmitFORMDialogController.this.asPanTextId.setText(SubmitFORMDialogController.this.asPanTextId.getText().toUpperCase());
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            });
            this.asPanTextId.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                    if (!t1.matches("^[0-9A-Za-z]{0,10}$")) {
                        SubmitFORMDialogController.this.asPanTextId.setText(t);
                    }
                    if (t1 != null && t1.length() > 10) {
                        SubmitFORMDialogController.this.asPanTextId.setText(t1.substring(0, 10));
                    }
                }
            });
            this.caPanText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    try {
                        SubmitFORMDialogController.this.caPanText.setText(SubmitFORMDialogController.this.caPanText.getText().toUpperCase());
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            });
            this.caPanText.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                    if (!t1.matches("^[0-9A-Za-z]{0,10}$")) {
                        SubmitFORMDialogController.this.caPanText.setText(t);
                    }
                    if (t1 != null && t1.length() > 10) {
                        SubmitFORMDialogController.this.caPanText.setText(t1.substring(0, 10));
                    }
                }
            });
            this.descId.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                    if (!t1.matches("^[0-9A-Za-z]{0,200}$")) {
                        SubmitFORMDialogController.this.descId.setText(t);
                    }
                    if (t1 != null && t1.length() > 200) {
                        SubmitFORMDialogController.this.descId.setText(t1.substring(0, 200));
                    }
                }
            });
        }
        this.password.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (t1 != null && t1.length() > 14) {
                    SubmitFORMDialogController.this.password.setText(t1.substring(0, 14));
                }
            }
        });
        this.dob.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                if (!t1.matches("^[0-9/]{0,10}$")) {
                    SubmitFORMDialogController.this.dob.setText(t);
                }
                if (t1 != null && t1.length() > 10) {
                    SubmitFORMDialogController.this.dob.setText(t1.substring(0, 10));
                }
            }
        });
    }

    @FXML
    public void hideDscTypeLabel() {
        this.dscTypeLabel.setDisable(true);
        this.dscTypeHbox.setDisable(true);
        this.hideOne();
        this.removeStyle();
    }

    @FXML
    public void showDscTypeLabel() {
        this.dscTypeLabel.setDisable(false);
        this.dscTypeHbox.setDisable(false);
        this.hideOne();
        this.removeStyle();
    }

    @FXML
    public void checkReasonRequired() {
        if (this.filingTypeCombo.getValue().toString().equals("Revised")) {
            this.showOtherReason();
        } else {
            this.hideReasonRelated();
        }
    }

    public void hideOne() {
        this.usbtokenLabelHbox.setDisable(true);
        this.usbtokenComboHbox.setDisable(true);
        this.pfxHbox.setDisable(true);
        this.keyFileHbox.setDisable(true);
        this.keyHbox.setDisable(true);
        this.key2Hbox.setDisable(true);
    }

    public void hideDscRelated() {
        if (FormConfigUtil.getFormNamesIndCo().containsKey(this.itrNameVar) || !FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar)) {
            this.dscTypeLabel.setDisable(true);
            this.dscTypeHbox.setDisable(true);
        }
        this.usbtokenLabelHbox.setDisable(true);
        this.usbtokenComboHbox.setDisable(true);
        this.pfxHbox.setDisable(true);
        this.keyFileHbox.setDisable(true);
        this.keyHbox.setDisable(true);
        this.key2Hbox.setDisable(true);
    }

    public void hideReasonRelated() {
        if (FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar)) {
            this.reasonHbox.setDisable(true);
            this.reasonBoxId.setDisable(true);
            this.descHbox.setDisable(true);
            this.descId.setDisable(true);
            this.descId.clear();
            this.reason1Type.setSelected(false);
            this.reason2Type.setSelected(false);
            this.reason3Type.setSelected(false);
            this.reason4Type.setSelected(false);
        }
    }

    public void hideFecthCA() {
        if (!FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar) && FormConfigUtil.getFormNamesIndCo().containsKey(this.itrNameVar)) {
            this.caUserLabelHbox.setVisible(false);
            this.caUserComboHbox.setVisible(false);
        }
    }

    public void hideYesNoDsc() {
        if (FormConfigUtil.getFormNamesDscMndtry().containsKey(this.itrNameVar)) {
            this.radioHboxLabel.setVisible(false);
            this.radioHbox.setVisible(false);
            this.radioYes.setVisible(false);
            this.radioNo.setVisible(false);
            this.dscTypeLabel.setDisable(false);
            this.dscTypeHbox.setDisable(false);
        }
    }

    public void showOtherReason() {
        if (FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar)) {
            this.reasonHbox.setDisable(false);
            this.reasonBoxId.setDisable(false);
            if (this.getReason4Type().isSelected()) {
                this.descHbox.setDisable(false);
                this.descId.setDisable(false);
            } else {
                this.descHbox.setDisable(true);
                this.descId.setDisable(true);
                this.descId.clear();
            }
        }
    }

    @FXML
    public void showPfxLabel() {
        this.usbtokenLabelHbox.setDisable(true);
        this.usbtokenComboHbox.setDisable(true);
        this.keyFileHbox.setDisable(false);
        this.key2Hbox.setDisable(false);
        this.pfxHbox.setDisable(false);
        this.keyHbox.setDisable(false);
        this.removeStyle();
    }

    @FXML
    public void showUsbLabel() {
        this.usbtokenLabelHbox.setDisable(false);
        this.usbtokenComboHbox.setDisable(false);
        this.keyFileHbox.setDisable(true);
        this.key2Hbox.setDisable(true);
        this.pfxHbox.setDisable(true);
        this.keyHbox.setDisable(true);
        this.removeStyle();
    }

    @FXML
    public void dscMandatory() {
        LOG.info("dscMandatory starts");
        if (this.sec44AB.isSelected()) {
            this.radioYes.setSelected(true);
            this.radioYes.setDisable(true);
            this.radioNo.setDisable(true);
            this.showDscTypeLabel();
        } else {
            this.radioYes.setSelected(false);
            this.radioYes.setDisable(false);
            this.radioNo.setDisable(false);
        }
        LOG.info("dscMandatory ends");
    }

    private void enableSec44AB() {
        if (this.itrNameVar.equals("FORMBB")) {
            this.sec44ABHbox.setVisible(true);
            this.sec44ABcheckHbox.setVisible(true);
        } else {
            this.sec44ABHbox.setVisible(false);
            this.sec44ABcheckHbox.setVisible(false);
        }
    }

    @FXML
    public void browse() {
        WebServiceUtilSingle.pfxFile = mainController.openFileDialog(false, ".pfx,.p12", null);
        if (WebServiceUtilSingle.pfxFile != null) {
            this.keyFile.setText(WebServiceUtilSingle.pfxFile.getName());
        }
    }

    @FXML
    public void submit() {
        try {
            if (!this.validateParam()) {
                return;
            }
            LOG.info("itrNameVar in submit:" + this.itrNameVar);
            if (FormConfigUtil.getFormNamesIndCo().containsKey(this.itrNameVar)) {
                LOG.info("Inside element check");
                WebServiceUtilSingle.is15CA = true;
            }
            this.errorText.setText("");
            WebServiceUtilSingle util = new WebServiceUtilSingle();
            WebServiceUtilSingle.controller = this;
            WebServiceUtilSingle.itrFile = SubmitFORMDialogController.mainController.outputFileSubmit;
            if (this.validateDSCKey(util)) {
                this.progress.setVisible(true);
                this.progress.setProgress(-1.0);
                this.initWebRequest();
                this.getSubmit().setDisable(true);
                Thread thread = new Thread((Runnable)((Object)util));
                thread.start();
            }
        }
        catch (Exception e) {
            LOG.error("submit error ", e);
            mainController.generateErrorDialog("Error in in submit,Please click on Submit again. ", true);
        }
    }

    @FXML
    public void fetchCA() {
        try {
            LOG.info("Inside fetchCA method starts");
            if (!this.validateCAParam()) {
                return;
            }
            this.errorText.setText("");
            GetCAUtil util = new GetCAUtil();
            GetCARequest getCARequest = GetCAUtil.getCARequest;
            GetCAUtil.controller = this;
            this.progress.setVisible(true);
            this.progress.setProgress(-1.0);
            getCARequest.setUserId(this.userId.getText());
            getCARequest.setAsstYear(this.asstYearVar);
            getCARequest.setFormName(this.itrNameVar);
            getCARequest.setDob(this.dob.getText());
            getCARequest.setPassword(this.password.getText());
            String select = (String)this.getCaUserId().getItems().get(0);
            ArrayList<String> list = new ArrayList<String>();
            list.add(select);
            this.getCaUserId().getItems().clear();
            this.getCaUserId().getItems().addAll(list);
            this.getCaUserId().getSelectionModel().selectFirst();
            Thread thread = new Thread((Runnable)((Object)util));
            thread.start();
        }
        catch (Exception e) {
            LOG.error("submit error ", e);
            mainController.generateErrorDialog("Error in in submit,Please click on Submit again. ", true);
        }
    }

    public void initWebRequest() throws Exception {
        if (WebServiceUtilSingle.is15CA) {
            LOG.info("For 15CA");
            FormUploadRequest request = WebServiceUtilSingle.request15CA;
            request.setUserId(this.userId.getText());
            request.setFormName(this.itrNameVar);
            if (this.itrNameVar.equalsIgnoreCase("FORM15CA")) {
                request.setAsstYear(null);
            } else {
                request.setAsstYear(this.asstYearVar);
            }
            if (this.userId.getText().matches("^[A-Za-z]{4}[0-9]{5}[a-zA-Z]{1}$")) {
                request.setDob(null);
            } else {
                request.setDob(this.dob.getText());
            }
            if (this.radioYes.isSelected() || FormConfigUtil.getFormNamesDscMndtry().containsKey(this.itrNameVar)) {
                request.setDscFlag("Y");
            } else {
                request.setDscFlag("N");
            }
            request.setNonAuditFlag("Y");
            request.setPassword(this.password.getText());
            request.setVersion(this.versionVar);
            request.setJarHash(CreateHash.generateHashSubmit());
            return;
        }
        SubmitFORMRequest request = WebServiceUtilSingle.submitFORMRequest;
        String listReason = null;
        LOG.info("userId. :" + this.userId);
        LOG.info("userId.getText( ) :" + this.userId.getText());
        request.setUserId(this.userId.getText());
        request.setFormName(this.itrNameVar);
        request.setAsstYear(this.asstYearVar);
        request.setDob(this.dob.getText());
        if (!FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar) && !FormConfigUtil.getFormNamesIndCo().containsKey(this.itrNameVar)) {
            request.setCaUserId((String)this.getCaUserId().getValue());
        }
        if (!FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar)) {
            LOG.info("Inside initWebRequest");
            if (this.radioYes.isSelected()) {
                request.setDscFlag("Y");
            } else {
                request.setDscFlag("N");
            }
        }
        if (FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar)) {
            request.setCaUserPan(this.caPanText.getText());
            request.setAsPan(this.asPanTextId.getText());
            request.setFormType((String)this.filingTypeCombo.getValue());
            if (this.reason1Type.isSelected()) {
                listReason = "1";
            }
            if (this.reason2Type.isSelected()) {
                listReason = listReason + ",2";
            }
            if (this.reason3Type.isSelected()) {
                listReason = listReason + ",3";
            }
            if (this.reason4Type.isSelected()) {
                listReason = listReason + ",4";
            }
            request.setRevisionReason(listReason);
            request.setDescription(this.descId.getText());
        }
        request.setVersion(this.versionVar);
        request.setJarHash(CreateHash.generateHashSubmit());
        request.setPassword(this.password.getText());
    }

    public boolean validateDSCKey(WebServiceUtilSingle util) {
        boolean flag = true;
        try {
            if (!(!WebServiceUtilSingle.is15CA && FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar) || this.radioYes.isSelected() || FormConfigUtil.getFormNamesDscMndtry().containsKey(this.itrNameVar))) {
                return true;
            }
            SignerUtil signerUtil = new SignerUtil();
            if (this.usbToken.isSelected()) {
                LOG.info("usb token selected");
                String alias = (String)this.usbCombo.getValue();
                signerUtil.intCertChainUsbToken(UsbTokenUtil.keyStore, alias);
                WebServiceUtilSingle.submitFORMRequest.setCertChain(signerUtil.getCertChain());
                WebServiceUtilSingle.request15CA.setCertChain(signerUtil.getCertChain());
                String signature = signerUtil.initSignature(new FileInputStream(WebServiceUtilSingle.itrFile));
                WebServiceUtilSingle.submitFORMRequest.setSignature(signature);
                WebServiceUtilSingle.request15CA.setSignature(signature);
            } else {
                LOG.info("pfx file selected");
                signerUtil.signFile(new FileInputStream(WebServiceUtilSingle.itrFile), new FileInputStream(WebServiceUtilSingle.pfxFile), this.passkey.getText());
                WebServiceUtilSingle.submitFORMRequest.setCertChain(signerUtil.getCertChain());
                WebServiceUtilSingle.submitFORMRequest.setSignature(signerUtil.getSignature());
                WebServiceUtilSingle.request15CA.setCertChain(signerUtil.getCertChain());
                WebServiceUtilSingle.request15CA.setSignature(signerUtil.getSignature());
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("javax.crypto.BadPaddingException") != -1) {
                this.errorText.setText(FormConfigUtil.getConfigProperty("invalid.dsc.password"));
            } else {
                this.errorText.setText(e.getMessage());
            }
            LOG.error("validateDSCKey error: ", e);
            flag = false;
        }
        LOG.info("validateDSCKey ends with flag: " + flag);
        return flag;
    }

    @FXML
    public void newUser() {
        LOG.info("newUser starts");
        MainLoader.hostServices.showDocument("https://incometaxindiaefiling.gov.in/e-Filing/Registration/RegistrationHome.html");
        LOG.info("newUser ends");
    }

    @FXML
    public void hideLabel() {
        LOG.info("hideLabel starts");
        this.radioHbox.getStyleClass().add((Object)"red-focused-Vbox-White");
        this.keyFileHbox.getStyleClass().remove((Object)"red-focused-Vbox");
        this.passkey.getStyleClass().remove((Object)"red-focused-class");
    }

    @FXML
    public void cancel() {
        LOG.info("cancel caled");
        this.myDialogStage.hide();
    }

    public boolean validateDscFlag() {
        boolean flag = true;
        this.removeStyle();
        if (!this.radioYes.isSelected() && !this.radioNo.isSelected()) {
            this.radioHbox.getStyleClass().remove((Object)"red-focused-Vbox-White");
            this.radioHbox.getStyleClass().add((Object)"red-focused-Vbox");
            flag = false;
            this.errorText.setText("Please select Yes or No option");
        } else if (this.radioYes.isSelected()) {
            flag = this.validateDscType();
        }
        String userIdVal = this.userId.getText();
        if (userIdVal != null && userIdVal.trim().toUpperCase().matches("[A-Za-z]{3}[C|c|A|a|T|t|B|b|G|g|f|F|j|J|l|L]{1}[A-Za-z]{1}[0-9]{4}[A-Za-z]{1}$") && !this.radioYes.isSelected()) {
            this.radioHbox.getStyleClass().remove((Object)"red-focused-Vbox-White");
            this.radioHbox.getStyleClass().add((Object)"red-focused-Vbox");
            flag = false;
        }
        return flag;
    }

    public void removeStyle() {
        this.removeStyle(this.usbtokenComboHbox);
        this.removeStyle(this.keyFileHbox);
        this.removeStyle(this.key2Hbox);
        if (FormConfigUtil.getFormNamesIndCo().containsKey(this.itrNameVar)) {
            this.removeStyle(this.dscTypeHbox);
            this.removeStyle(this.radioHbox);
        }
        this.passkey.getStyleClass().remove((Object)"red-focused-class");
    }

    public void removeStyle(HBox hbox) {
        ObservableList styleList = hbox.getStyleClass();
        hbox.getStyleClass().removeAll((Collection)styleList);
        hbox.getStyleClass().add((Object)"red-focused-Vbox-White");
    }

    public boolean validateDscType() {
        boolean flag = true;
        if (!this.pfxtype.isSelected() && !this.usbToken.isSelected()) {
            flag = false;
            this.dscTypeHbox.getStyleClass().remove((Object)"red-focused-Vbox-White");
            this.dscTypeHbox.getStyleClass().add((Object)"red-focused-Vbox");
            this.errorText.setText("Please select type of DSC.");
        } else {
            this.dscTypeHbox.getStyleClass().remove((Object)"red-focused-Vbox");
            this.dscTypeHbox.getStyleClass().add((Object)"red-focused-Vbox-White");
        }
        if (this.usbToken.isSelected()) {
            if ("Select Certificate".equals((String)this.usbCombo.getValue())) {
                this.usbtokenComboHbox.getStyleClass().remove((Object)"red-focused-Vbox-White");
                this.usbtokenComboHbox.getStyleClass().add((Object)"red-focused-Vbox");
                flag = false;
            } else {
                this.usbtokenComboHbox.getStyleClass().add((Object)"red-focused-Vbox-White");
            }
        }
        if (this.pfxtype.isSelected()) {
            this.passkey.getStyleClass().remove((Object)"red-focused-class");
            if (this.keyFile.getText().length() == 0) {
                this.keyFileHbox.getStyleClass().remove((Object)"red-focused-Vbox-White");
                this.keyFileHbox.getStyleClass().add((Object)"red-focused-Vbox");
                flag = false;
            } else {
                this.keyFileHbox.getStyleClass().add((Object)"red-focused-Vbox-White");
            }
            if (this.passkey.getText().length() == 0) {
                this.passkey.getStyleClass().add((Object)"red-focused-class");
                flag = false;
            } else {
                this.passkey.getStyleClass().remove((Object)"red-focused-class");
            }
        }
        return flag;
    }

    public boolean validateUserId() {
        boolean flag = true;
        this.errorText.setText("");
        if (this.userId.getText().trim().length() == 0) {
            this.userId.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.userId.requestFocus();
            this.errorText.setText("Please enter the User ID.");
        } else if (this.userId.getText().trim().length() < 10) {
            this.userId.getStyleClass().add((Object)"red-focused-class");
            this.userId.requestFocus();
            flag = false;
            this.errorText.setText("Invalid User ID. Please retry.");
        } else {
            this.userId.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateAsPan() {
        boolean flag = true;
        if (this.asPanTextId.getText().trim().length() == 0) {
            this.asPanTextId.getStyleClass().add((Object)"red-focused-class");
            this.asPanTextId.requestFocus();
            flag = false;
            this.errorText.setText("Please enter Assessee PAN");
        } else if (this.asPanTextId.getText().trim().length() < 10) {
            this.asPanTextId.getStyleClass().add((Object)"red-focused-class");
            this.asPanTextId.requestFocus();
            flag = false;
            this.errorText.setText("Invalid Assessee PAN. Please retry.");
        } else if (!this.asPanTextId.getText().trim().toUpperCase().matches("[A-Z]{5}[0-9]{4}[A-Z]{1}")) {
            this.asPanTextId.getStyleClass().add((Object)"red-focused-class");
            this.asPanTextId.requestFocus();
            flag = false;
            this.errorText.setText("Invalid Assessee PAN. Please retry.");
        } else {
            this.asPanTextId.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateCaPan() {
        boolean flag = true;
        if (this.caPanText.getText().trim().length() == 0) {
            this.caPanText.requestFocus();
            this.caPanText.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.errorText.setText("Please enter CA PAN");
        } else if (this.caPanText.getText().trim().length() < 10) {
            this.caPanText.getStyleClass().add((Object)"red-focused-class");
            this.caPanText.requestFocus();
            flag = false;
            this.errorText.setText("Invalid CA PAN. Please retry.");
        } else if (!this.caPanText.getText().trim().toUpperCase().matches("[A-Z]{5}[0-9]{4}[A-Z]{1}")) {
            this.caPanText.getStyleClass().add((Object)"red-focused-class");
            this.caPanText.requestFocus();
            flag = false;
            this.errorText.setText("Invalid Assessee PAN. Please retry.");
        } else {
            this.caPanText.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateformType() {
        boolean flag = true;
        if (this.filingTypeCombo.getValue().toString().equals("Select Filing Type")) {
            this.filingTypeCombo.requestFocus();
            this.filingTypeCombo.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.errorText.setText("Please select filing type");
        } else {
            this.filingTypeCombo.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateReason() {
        boolean flag = true;
        if (!(!this.filingTypeCombo.getValue().toString().equals("Revised") || this.reason1Type.isSelected() || this.reason2Type.isSelected() || this.reason3Type.isSelected() || this.reason4Type.isSelected())) {
            this.reasonBoxId.getStyleClass().remove((Object)"red-focused-Vbox-White");
            this.reasonBoxId.getStyleClass().add((Object)"red-focused-class");
            this.reasonBoxId.getStyleClass().add((Object)"red-focused-Vbox");
            this.reasonBoxId.requestFocus();
            flag = false;
            this.errorText.setText("Please select reason for revision");
        } else {
            this.reasonBoxId.getStyleClass().remove((Object)"red-focused-Vbox");
            this.reasonBoxId.getStyleClass().add((Object)"red-focused-Vbox-White");
            this.reasonBoxId.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateOtherReason() {
        boolean flag = true;
        if (this.filingTypeCombo.getValue().toString().equals("Revised") && this.reason4Type.isSelected() && this.descId.getText().trim().length() == 0) {
            this.descId.getStyleClass().add((Object)"red-focused-class");
            this.descId.requestFocus();
            flag = false;
            this.errorText.setText("Please enter description");
        } else {
            this.descId.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateCAUser() {
        boolean flag = true;
        if (!FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar) && !FormConfigUtil.getFormNamesIndCo().containsKey(this.itrNameVar)) {
            if (this.getCaUserId().getValue().toString().equals("Select CA")) {
                this.getCaUserId().getStyleClass().add((Object)"red-focused-class");
                this.caUserId.requestFocus();
                flag = false;
                this.errorText.setText("Please select CA User");
            } else {
                this.getCaUserId().getStyleClass().remove((Object)"red-focused-class");
            }
        }
        return flag;
    }

    public boolean validatePassword() {
        boolean flag = true;
        this.errorText.setText("");
        if (this.password.getText().trim().length() == 0) {
            this.password.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.password.requestFocus();
            this.errorText.setText("Please enter a Password.");
        } else if (this.password.getText().trim().length() < 8) {
            this.password.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.password.requestFocus();
            this.errorText.setText("Invalid Password. Please retry.");
        } else {
            this.password.getStyleClass().remove((Object)"red-focused-class");
        }
        return flag;
    }

    public boolean validateDob() {
        boolean flag = true;
        this.errorText.setText("");
        if (this.userId != null && this.userId.getText().trim().toUpperCase().matches("[A-Z]{4}[0-9]{5}[A-Z]{1}")) {
            return flag;
        }
        if (this.dob.getText().trim().length() == 0) {
            this.dob.getStyleClass().add((Object)"red-focused-class");
            flag = false;
            this.dob.requestFocus();
            this.errorText.setText("Please enter a Date of Birth/Incorporation");
        } else {
            try {
                DD_MM_YY_DATE_FORMAT.parse(this.dob.getText());
                this.dob.getStyleClass().remove((Object)"red-focused-class");
            }
            catch (Exception e) {
                this.dob.getStyleClass().add((Object)"red-focused-class");
                flag = false;
                this.dob.requestFocus();
                this.errorText.setText("Incorrect Date of Birth/Incorporation. Please retry");
            }
        }
        return flag;
    }

    public boolean validateParam() {
        boolean flag = true;
        flag = flag && this.validateUserId();
        flag = flag && this.validatePassword();
        flag = flag && this.validateDob();
        LOG.info("itrNameVar:::" + this.itrNameVar + "asstYearVar::" + this.asstYearVar);
        if (FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar)) {
            flag = flag && this.validateAsPan();
            flag = flag && this.validateCaPan();
            flag = flag && this.validateformType();
            flag = flag && this.validateformType();
            flag = flag && this.validateReason();
            flag = flag && this.validateOtherReason();
        } else {
            boolean bl = flag = flag && this.validateCAUser();
        }
        if (!FormConfigUtil.isCaFlag(this.itrNameVar, this.asstYearVar, this.isCaFlagVar) && !FormConfigUtil.getFormNamesDscMndtry().containsKey(this.itrNameVar)) {
            LOG.info("check dsc");
            flag = flag && this.validateDscFlag();
        } else {
            LOG.info("check dsc type");
            flag = flag && this.validateDscType();
        }
        return flag;
    }

    public boolean validateCAParam() {
        boolean flag = true;
        flag = flag && this.validateUserId();
        flag = flag && this.validatePassword();
        flag = flag && this.validateDob();
        return flag;
    }

    public Stage getMyDialogStage() {
        return this.myDialogStage;
    }

    public void setMyDialogStage(Stage myDialogStage) {
        this.myDialogStage = myDialogStage;
    }

    public WebEngine getItrEngine() {
        return this.itrEngine;
    }

    public void setItrEngine(WebEngine itrEngine) {
        this.itrEngine = itrEngine;
    }

    public TextField getUserId() {
        return this.userId;
    }

    public void setUserId(TextField userId) {
        this.userId = userId;
    }

    public TextField getPassword() {
        return this.password;
    }

    public void setPassword(TextField password) {
        this.password = password;
    }

    public TextField getDob() {
        return this.dob;
    }

    public void setDob(TextField dob) {
        this.dob = dob;
    }

    public Text getItr() {
        return this.itr;
    }

    public void setItr(Text itr) {
        this.itr = itr;
    }

    public Text getAsstYear() {
        return this.asstYear;
    }

    public void setAsstYear(Text asstYear) {
        this.asstYear = asstYear;
    }

    public Text getUserPan() {
        return this.userPan;
    }

    public void setUserPan(Text userPan) {
        this.userPan = userPan;
    }

    public Text getVerifPan() {
        return this.verifPan;
    }

    public void setVerifPan(Text verifPan) {
        this.verifPan = verifPan;
    }

    public ToggleGroup getRadioGroup() {
        return this.radioGroup;
    }

    public void setRadioGroup(ToggleGroup radioGroup) {
        this.radioGroup = radioGroup;
    }

    public Button getSelectCerFile() {
        return this.selectCerFile;
    }

    public void setSelectCerFile(Button selectCerFile) {
        this.selectCerFile = selectCerFile;
    }

    public TextField getPasskey() {
        return this.passkey;
    }

    public void setPasskey(TextField passkey) {
        this.passkey = passkey;
    }

    public Label getLabel1() {
        return this.label1;
    }

    public void setLabel1(Label label1) {
        this.label1 = label1;
    }

    public Label getLavel2() {
        return this.lavel2;
    }

    public void setLavel2(Label lavel2) {
        this.lavel2 = lavel2;
    }

    public HBox getRadioHbox() {
        return this.radioHbox;
    }

    public void setRadioHbox(HBox radioHbox) {
        this.radioHbox = radioHbox;
    }

    public MainController getMainController() {
        return mainController;
    }

    public static void setMainController(MainController mainController1) {
        mainController = mainController1;
    }

    public RadioButton getRadioYes() {
        return this.radioYes;
    }

    public void setRadioYes(RadioButton radioYes) {
        this.radioYes = radioYes;
    }

    public RadioButton getRadioNo() {
        return this.radioNo;
    }

    public void setRadioNo(RadioButton radioNo) {
        this.radioNo = radioNo;
    }

    public HBox getKeyFileHbox() {
        return this.keyFileHbox;
    }

    public void setKeyFileHbox(HBox keyFileHbox) {
        this.keyFileHbox = keyFileHbox;
    }

    public Text getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText.setText(errorText);
    }

    public Text getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(Text keyFile) {
        this.keyFile = keyFile;
    }

    public String getItrNameVar() {
        return this.itrNameVar;
    }

    public void setItrNameVar(String itrNameVar) {
        this.itrNameVar = itrNameVar;
    }

    public String getAsstYearVar() {
        return this.asstYearVar;
    }

    public void setAsstYearVar(String asstYearVar) {
        this.asstYearVar = asstYearVar;
    }

    public ProgressBar getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressBar progress) {
        this.progress = progress;
    }

    public Button getSubmit() {
        return this.submit;
    }

    public void setSubmit(Button submit) {
        this.submit = submit;
    }

    public TextField getCaPanText() {
        return this.caPanText;
    }

    public TextField getAsPanTextId() {
        return this.asPanTextId;
    }

    public ComboBox getCaUserId() {
        return this.caUserId;
    }

    public TextArea getDescId() {
        return this.descId;
    }

    public CheckBox getReason1Type() {
        return this.reason1Type;
    }

    public CheckBox getReason2Type() {
        return this.reason2Type;
    }

    public CheckBox getReason3Type() {
        return this.reason3Type;
    }

    public void setReason3Type(CheckBox reason3Type) {
        this.reason3Type = reason3Type;
    }

    public CheckBox getReason4Type() {
        return this.reason4Type;
    }

    public void setAsPanTextId(TextField asPanTextId) {
        this.asPanTextId = asPanTextId;
    }
}

