/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

public class HelpLayoutController
implements Initializable {
    static final Logger LOG = Logger.getLogger(HelpLayoutController.class);
    private Stage myDialogStage;
    private MainController mainController;
    @FXML
    WebView helpWebView;
    WebEngine helpEngine;

    public void initialize(URL url, ResourceBundle rb) {
        LOG.info("initialize starts");
        this.helpEngine = this.helpWebView.getEngine();
        this.helpEngine.getHistory().setMaxSize(1);
        this.helpEngine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                LOG.info("helpEngine alert: " + t);
            }
        });
        this.helpWebView.setContextMenuEnabled(false);
        this.initHelpPage();
        LOG.info("initialize ends");
    }

    public void show() {
        this.myDialogStage.sizeToScene();
        this.myDialogStage.show();
    }

    public void hide() {
        this.myDialogStage.hide();
    }

    public void initHelpPage() {
        try {
            String helpPage = null;
            LOG.info("asstYear " + MainController.asstYear + "itrName" + MainController.itrName);
            helpPage = FormConfigUtil.getHelpPage(MainController.itrName, MainController.asstYear, MainController.version);
            LOG.info("initHelpPage starts with page: " + helpPage);
            this.helpEngine.load(helpPage);
            this.helpEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State t1) {
                    LOG.info("Stage changed in help " + t + " " + t1);
                    if (t1.equals((Object)Worker.State.SUCCEEDED)) {
                        // empty if block
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("initHelpPage ", e);
        }
    }

    public Stage getMyDialogStage() {
        return this.myDialogStage;
    }

    public void setMyDialogStage(Stage myDialogStage) {
        this.myDialogStage = myDialogStage;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public WebView getHelpWebView() {
        return this.helpWebView;
    }

    public void setHelpWebView(WebView helpWebView) {
        this.helpWebView = helpWebView;
    }

    public WebEngine getHelpEngine() {
        return this.helpEngine;
    }

    public void setHelpEngine(WebEngine helpEngine) {
        this.helpEngine = helpEngine;
    }
}

