/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validators;

import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;

public class StringLengthFieldValidator
extends ValidatorInteface {
    private int maxLength;
    private int minLength;
    private boolean doTrim;

    @Override
    public void validate(String val, String name, Validator validator) throws ValidationException {
        if (val == null || val.length() <= 0) {
            return;
        }
        if (this.doTrim && (val = val.trim()).length() <= 0) {
            return;
        }
        if (!val.matches("|(\\s*([\\w\\d_=!@#$%\\^*\\(\\){}\\[\\]\\|\\\\:;',\\.\\?/~`\\-\\+&lt;&gt;&amp;&quot;][\\s\\w\\d_=!@#$%\\^*\\(\\){}\\[\\]\\|\\\\:;',\\.\\?/~`\\-\\+&lt;&gt;&amp;&quot;]*)\\s*)")) {
            this.setMessageKey("Invalid characters(s) in input");
            this.addFieldError(name, validator);
        }
        if (this.minLength > -1 && val.length() < this.minLength) {
            this.addFieldError(name, validator);
        } else if (this.maxLength > -1 && val.length() > this.maxLength) {
            this.addFieldError(name, validator);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public boolean isDoTrim() {
        return this.doTrim;
    }

    public void setDoTrim(boolean doTrim) {
        this.doTrim = doTrim;
    }
}

