/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.ValidationCacher;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.web.WebEngine;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLSelectElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTextAreaElement;

public class FormUtil
extends Task<Void> {
    public static final com.tcs.efiling.form.config.Logger LOG = com.tcs.efiling.form.config.Logger.getLogger(FormUtil.class);
    private Validator validator;
    static Map<String, List<String>> FIELD_VALUE = new LinkedHashMap<String, List<String>>();
    static MainController mainController;
    static String outputfilePath;
    String itrName;
    String asstYear;
    String ver;
    String pan;
    String isCaFlag = MainController.isCaFlag;
    final int barToBeUpdatedCount = 30;
    boolean schemaValidationFlag = false;
    boolean isSchemaFlag = false;
    public static Map<String, Object> IMPORT_XML_MAP;
    public static Map<String, String> HTML_FIELD_MAP;
    static int count2;
    static int noset;
    static boolean issaveDraft;
    private static Document xmlDoc;
    static int nodeIndexCount;
    public static final Map<String, Map<String, String>> IMPORT_KEY_VAL_MAP;
    public static String currTableVal;
    public static String currTableXpath;
    public static Map<String, List<String>> IMPORT_HTML_FIELD_VALUE;
    private static Map<String, Integer> tableNodes;
    private static Map<String, Map<String, Integer>> currentNode;
    static int index2;
    private static Document importXmlDoc;
    static boolean isImportMultiple;
    static boolean isRootForm;
    public static final SimpleDateFormat TIMESTAMP_FORMAT;
    public static List<String> tempList;
    List<String> schemaError;
    boolean generateXmlFlag;
    static int nodeValZeroCount;
    static int nodeValNonZeroCount;

    public FormUtil() {
    }

    public FormUtil(String itrName, String asstYear, String ver) {
        try {
            this.asstYear = asstYear;
            this.itrName = itrName;
            this.ver = ver;
            xmlDoc = FormCacher.getDocument(FormConfigUtil.getSampleXmlFile(itrName, asstYear, ver));
            this.modifyXMLFromCSV();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            ValidationCacher.loadDoc("FORM3CB3CD", "2014-15", "1.0");
            Document doc = FormCacher.getDocument("file:\\C:\\Users\\748232\\Desktop\\abcddddd.xml");
            FormUtil.modifyXmlDoc("form3CdFirmAopDetailPK.3cb7a[1].firmAopDesc", doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void addToFieldNameValue(WebEngine itrEngine) {
        FIELD_VALUE.clear();
        long time1 = System.currentTimeMillis();
        Object obj = itrEngine.executeScript("getNameVals();");
        JSObject jsObject = (JSObject)obj;
        int len = (Integer)jsObject.getMember("length");
        for (int i = 0; i < len; ++i) {
            JSObject objj = (JSObject)jsObject.getSlot(i);
            String name = objj.getMember("name").toString();
            String val = objj.getMember("value").toString();
            if (FIELD_VALUE.containsKey(name)) {
                FIELD_VALUE.get(name).add(val);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(val);
            FIELD_VALUE.put(name, list);
        }
        long time2 = System.currentTimeMillis();
        LOG.debug("Time taken in addToFieldNameValue(): " + (time2 - time1));
    }

    public void removeNodes(Document doc) throws Exception {
        LOG.info("removeNodes starts");
        if (FormConfigUtil.exportMultiple(this.itrName, this.asstYear, this.ver)) {
            for (String key : FormConfigUtil.EXPORT_MULTIPLE_VALUES.keySet()) {
                String value = FormConfigUtil.EXPORT_MULTIPLE_VALUES.get(key);
                NodeList keyNodeList = (NodeList)FormCacher.xpath.evaluate(key, doc, XPathConstants.NODESET);
                NodeList valueNodeList = (NodeList)FormCacher.xpath.evaluate(value, doc, XPathConstants.NODESET);
                int keyNodeLength = keyNodeList.getLength();
                Node parent = null;
                Node grandParent = null;
                for (int i = 0; i < keyNodeLength; ++i) {
                    Node keyNode = keyNodeList.item(i);
                    if (parent == null) {
                        parent = keyNode.getParentNode();
                        grandParent = parent.getParentNode();
                    }
                    if (keyNodeLength <= 0) continue;
                    grandParent.insertBefore(keyNode, parent);
                }
                if (parent == null) continue;
                parent.getParentNode().removeChild(parent);
            }
        }
        LOG.info("removeNodes ends");
    }

    public synchronized void generateXmlModified() throws Exception {
        if (xmlDoc == null) {
            xmlDoc = FormCacher.getDocument(FormConfigUtil.getSampleXmlFile(this.itrName, this.asstYear, this.ver));
        }
        tempList.clear();
        this.addTableToDoc(xmlDoc);
        this.setNodeValues(xmlDoc);
        this.removeNodes(xmlDoc);
        FormUtil.removeAttr(xmlDoc);
        if (!this.generateXmlFlag) {
            xmlDoc.getDocumentElement().setAttribute("savedraft", "yes");
            issaveDraft = false;
        } else {
            xmlDoc.getDocumentElement().removeAttribute("savedraft");
        }
        FormUtil.wirteToFile(new File(outputfilePath), xmlDoc);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!FormUtil.mainController.generateXmlFlag) {
                    if (FormUtil.mainController.saveDraft) {
                        mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("msg.xml.draft.saved.success"), false);
                        mainController.getItrEngine().executeScript("setFileModifiedFalse()");
                        FormUtil.mainController.saveDraft = false;
                    } else {
                        mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("msg.xml.saved.success"), false);
                    }
                }
                FormUtil.mainController.saveFile.setDisable(false);
            }
        });
    }

    private void modifyXMLFromCSV() {
        mainController.getItrEngine().executeScript("beforeSave();");
    }

    public void addTableToDoc(Document doc) {
        for (String fieldName : FIELD_VALUE.keySet()) {
            if (fieldName.indexOf("[") == -1) continue;
            FormUtil.addTableDoc(fieldName, doc);
        }
    }

    public void setNodeValues(Node node) {
        Element element;
        String fieldName;
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                if (nodeTemp.getNodeType() != 3) {
                    this.setNodeValues(nodeTemp);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node.getNodeType() == 1 && (fieldName = (element = (Element)node).getAttribute("name")) != null && fieldName.length() != 0) {
            int len = node.getChildNodes().getLength();
            List<String> valList = FIELD_VALUE.get(fieldName);
            String val = null;
            if (valList != null && valList.size() > 0) {
                val = valList.get(0);
                if (valList.size() > 1) {
                    valList.remove(0);
                }
            }
            if (val != null && val.length() != 0) {
                if (val.matches("^[0-9]{2}(/)[0-9]{2}(/)[0-9]{4}$")) {
                    val = val.substring(6) + "-" + val.substring(3, 5) + "-" + val.substring(0, 2);
                }
                if (len == 0) {
                    node.setTextContent(val);
                } else if (len == 1) {
                    node.setNodeValue(val);
                    node.setTextContent(val);
                }
            }
        }
    }

    public static String getXpathForTableCell(String name) {
        String xpath = null;
        String tempName = name.replaceAll("\\[[0-9]*\\]", "[0]");
        xpath = ValidationCacher.getXPath(tempName);
        if (xpath != null) {
            int count = name.split("\\[").length;
            int t1 = 0;
            int t2 = 0;
            int x1 = 0;
            int x2 = 0;
            for (int i = 1; i < count; ++i) {
                t1 = name.indexOf("[", t1 + 1);
                t2 = name.indexOf("]", t2 + 1);
                x1 = xpath.indexOf("[", x1 + 1);
                x2 = xpath.indexOf("[", x2 + 1);
                int val = Integer.parseInt(name.substring(t1 + 1, t2)) + 1;
                xpath = xpath.substring(0, x1 + 1) + val + xpath.substring(x1 + 2, xpath.length());
            }
        }
        return xpath;
    }

    public static void check() throws Exception {
    }

    public static void iterateNode2(Node node, String nodeName) {
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                String name = nodeTemp.getNodeName();
                if (name.contains(":")) {
                    name = name.substring(name.lastIndexOf(":") + 1);
                }
                if (nodeTemp.getNodeType() != 3) {
                    FormUtil.iterateNode2(nodeTemp, nodeName + "/" + name);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null && node.getNodeType() == 1) {
            String fieldName = ValidationCacher.XPATH_TO_FIELD.get(nodeName);
            if (node.getChildNodes().getLength() == 1 || node.getChildNodes().getLength() == 0) {
                Element element = (Element)node;
                element.setAttribute("name", fieldName);
            }
        }
    }

    public static void iterateNodeImportXml(Node node, String nodeName, String str) {
        ++nodeIndexCount;
        String psedoNodeName = nodeName;
        if (node.getNodeType() != 3) {
            int i;
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            String tmpcurrTableVal = null;
            String tmpcurrTableXpath = null;
            tmpcurrTableVal = null;
            tmpcurrTableXpath = null;
            for (i = 0; i < nodeCount; ++i) {
                String val = null;
                String childName = nodeName + "/" + nodeList.item(i).getNodeName();
                if (childName.contains(":")) {
                    childName = nodeName + "/" + childName.substring(childName.lastIndexOf(":") + 1);
                }
                if (node.getNodeType() != 1 || nodeList.item(i).getChildNodes().getLength() != 1 && nodeList.item(i).getChildNodes().getLength() != 0) continue;
                val = nodeList.item(i).getTextContent();
                if (val != null && val.matches("^[0-9]{4}(-)[0-9]{2}(-)[0-9]{2}$")) {
                    val = val.substring(8) + "/" + val.substring(5, 7) + "/" + val.substring(0, 4);
                }
                if (!isImportMultiple || !FormConfigUtil.isEligible(childName)) continue;
                String type = (String)FormConfigUtil.IMPORT_MULTIPLE.get(childName);
                LOG.info("Multiple Type:" + type);
                LOG.info("Multiple val:" + val);
                if (type == null) continue;
                tmpcurrTableVal = (String)FormConfigUtil.IMPORT_MULTIPLE.get(type + "." + val);
                if (ValidationUtil.isStringEmpty(tmpcurrTableVal)) {
                    tmpcurrTableVal = (String)FormConfigUtil.IMPORT_MULTIPLE.get(type + ".*");
                }
                tmpcurrTableXpath = (String)FormConfigUtil.IMPORT_MULTIPLE.get(type + ".rootXpath");
                LOG.info("tmpcurrTableVal val:" + tmpcurrTableVal);
                LOG.info("tmpcurrTableXpath val:" + tmpcurrTableXpath);
                if (tmpcurrTableXpath == null || tmpcurrTableVal == null) continue;
                currTableXpath = tmpcurrTableXpath;
                currTableVal = tmpcurrTableVal;
                break;
            }
            if (currTableXpath != null && currTableVal != null) {
                psedoNodeName = nodeName.replace(currTableXpath, currTableVal);
            }
            for (i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                String name = nodeTemp.getNodeName();
                if (name.contains(":")) {
                    name = name.substring(name.lastIndexOf(":") + 1);
                }
                if (nodeTemp.getNodeType() != 3) {
                    FormUtil.iterateNodeImportXml(nodeTemp, nodeName + "/" + name, str + "," + nodeIndexCount);
                }
                nodeCount = nodeList.getLength();
            }
            if (currTableXpath != null && currTableVal != null) {
                psedoNodeName = nodeName.replace(currTableXpath + "/", currTableVal + "/");
                if (currTableXpath.equals(nodeName)) {
                    psedoNodeName = nodeName.replace(currTableXpath, currTableVal);
                }
            }
        }
        String val = null;
        if (node.getNodeType() == 1 && (node.getChildNodes().getLength() == 1 || node.getChildNodes().getLength() == 0) && (val = node.getTextContent()) != null && val.matches("^[0-9]{4}(-)[0-9]{2}(-)[0-9]{2}$")) {
            val = val.substring(8) + "/" + val.substring(5, 7) + "/" + val.substring(0, 4);
        }
        if (IMPORT_KEY_VAL_MAP.containsKey(psedoNodeName)) {
            IMPORT_KEY_VAL_MAP.get(psedoNodeName).put(str, val);
        } else {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(str, val);
            IMPORT_KEY_VAL_MAP.put(psedoNodeName, map);
        }
    }

    public static void putValuesToHTML(WebEngine itrEngine) {
        IMPORT_HTML_FIELD_VALUE.clear();
        Set<String> keySet = IMPORT_KEY_VAL_MAP.keySet();
        for (String key : keySet) {
            try {
                ArrayList<String> list;
                String htmlFieldName = ValidationCacher.XPATH_TO_FIELD.get(key);
                LOG.info("htmlFieldName" + htmlFieldName);
                if (htmlFieldName == null) continue;
                Map<String, String> valMap = IMPORT_KEY_VAL_MAP.get(key);
                if (htmlFieldName.indexOf("[") != -1) {
                    FormUtil.putValuesToHTMLForTable(key, itrEngine);
                    continue;
                }
                if (valMap.size() == 1) {
                    list = new ArrayList<String>();
                    list.add(valMap.entrySet().iterator().next().getValue());
                    IMPORT_HTML_FIELD_VALUE.put(htmlFieldName, list);
                    continue;
                }
                if (valMap.size() <= 1) continue;
                list = new ArrayList();
                for (String keys : valMap.keySet()) {
                    list.add(valMap.get(keys));
                }
                IMPORT_HTML_FIELD_VALUE.put(htmlFieldName, list);
            }
            catch (Exception e) {
                LOG.error("Error in putValuesToHTML in key:" + key);
                LOG.error("Error in putValuesToHTML: ", e);
            }
        }
        LOG.info("IMPORT_HTML_FIELD_VALUE: " + IMPORT_HTML_FIELD_VALUE);
        FormUtil.setValuesInForm(itrEngine);
    }

    public static void setValuesSingle(String htmlFieldName, String val, int index, WebEngine itrEngine) {
        try {
            val = URLEncoder.encode(val, "UTF-8").replaceAll("\\+", "%20");
            if (val.trim().length() != 0) {
                itrEngine.executeScript("setValues('" + htmlFieldName + "','" + val + "','" + index + "');");
            }
        }
        catch (Exception e) {
            LOG.error("Error in setValuesSingle: " + htmlFieldName + " val:" + val + ", index:" + index);
        }
    }

    public static void putValuesToHTMLForTable(String key, WebEngine itrEngine) {
        String htmlFieldName;
        String tempfieldName = htmlFieldName = ValidationCacher.XPATH_TO_FIELD.get(key);
        Map<String, String> valMap = IMPORT_KEY_VAL_MAP.get(key);
        for (String valKey : valMap.keySet()) {
            List<Object> list;
            int indexOf = 0;
            LOG.info("htmlFieldName before: " + htmlFieldName);
            String lastTimeTempIndex = "";
            int preCount = 0;
            for (int i = 0; i < htmlFieldName.split("\\[").length - 1; ++i) {
                indexOf = htmlFieldName.indexOf("[", indexOf + 1);
                int tempLen = htmlFieldName.substring(indexOf).split("\\.").length - 1;
                String[] tempStr = key.split("/");
                String[] tempIndexArr = valKey.split(",");
                String temp = "/";
                String tempIndex = ",";
                int tempLen2 = tempStr.length - tempLen;
                if (!isRootForm && !isImportMultiple) {
                    tempLen2 += tempLen;
                }
                for (int j = 1; j < tempLen2; ++j) {
                    temp = temp + tempStr[j];
                    tempIndex = tempIndex + tempIndexArr[j];
                    if (j != tempLen2 - 1) {
                        temp = temp + "/";
                        tempIndex = tempIndex + ",";
                    }
                    LOG.info("temp" + temp + " tempStr[j]" + tempStr[j]);
                }
                LOG.info("temp: " + temp);
                Map<String, String> tempMap = IMPORT_KEY_VAL_MAP.get(temp);
                int count = 0;
                for (String tempKey : tempMap.keySet()) {
                    LOG.info("tempKey: " + tempKey + ": tempIndex:" + tempIndex + ":count" + count);
                    if (tempIndex.equals(tempKey)) break;
                    if (i == 0) {
                        ++count;
                        continue;
                    }
                    if (!tempKey.contains(lastTimeTempIndex)) continue;
                    ++count;
                }
                tempfieldName = tempfieldName.substring(0, indexOf + String.valueOf(preCount).length()) + Integer.toString(count) + tempfieldName.substring(tempfieldName.indexOf("]", indexOf));
                lastTimeTempIndex = tempIndex;
                preCount = count;
            }
            LOG.info("htmlFieldName after: " + tempfieldName);
            if (IMPORT_HTML_FIELD_VALUE.containsKey(tempfieldName)) {
                list = IMPORT_HTML_FIELD_VALUE.get(tempfieldName);
                list.add(valMap.get(valKey));
                continue;
            }
            list = new ArrayList();
            list.add(valMap.get(valKey));
            IMPORT_HTML_FIELD_VALUE.put(tempfieldName, list);
        }
    }

    public static void setValuesInForm(WebEngine itrEngine) {
        for (String key : IMPORT_HTML_FIELD_VALUE.keySet()) {
            List<String> valList = IMPORT_HTML_FIELD_VALUE.get(key);
            if (valList.size() == 1) {
                FormUtil.setValuesSingle(key, valList.get(0), 0, itrEngine);
                continue;
            }
            for (int i = 0; i < valList.size(); ++i) {
                String val = valList.get(i);
                FormUtil.setValuesSingle(key, val, i, itrEngine);
            }
        }
    }

    public static void iterateNode(Node node, String nodeName) throws Exception {
        int nodeCount;
        NodeList nodeList;
        if (node.getNodeType() != 3) {
            nodeList = node.getChildNodes();
            nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                String name = nodeTemp.getNodeName();
                if (name.contains(":")) {
                    name = name.substring(name.lastIndexOf(":") + 1);
                }
                if (nodeTemp.getNodeType() != 3) {
                    FormUtil.iterateNode(nodeTemp, nodeName + "/" + name);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null && node.getNodeType() == 1) {
            nodeList = node.getChildNodes();
            nodeCount = nodeList.getLength();
            String val = null;
            if (nodeCount == 1) {
                val = node.getTextContent();
                if (val != null && val.trim().length() != 0) {
                    HashMap<String, Object> tempMap;
                    List<String> list = null;
                    if (val.contains("'")) {
                        val = val.replaceAll("'", "'");
                    }
                    String tempFieldName = FormUtil.getMultipleTableFieldName(nodeName);
                    String[] str = null;
                    if (tempFieldName != null && tempFieldName.length() != 0) {
                        str = tempFieldName.split("\\[");
                    }
                    String tableName = "";
                    if (str != null && str.length > 1) {
                        tableName = tempFieldName.substring(0, tempFieldName.indexOf("["));
                        if (currentNode.containsKey(tableName)) {
                            if (currentNode.get(tableName).containsKey(tempFieldName)) {
                                currentNode.get(tableName).put(tempFieldName, currentNode.get(tableName).get(tempFieldName) + 1);
                            }
                        } else {
                            tempMap = new HashMap<String, Object>();
                            tempMap.put(tempFieldName, 0);
                            currentNode.put(tableName, tempMap);
                        }
                    }
                    if (IMPORT_XML_MAP.containsKey(nodeName) || str != null && str.length > 2) {
                        if (str != null && str.length > 2) {
                            tempMap = (HashMap<String, Object>)IMPORT_XML_MAP.get(nodeName);
                            int index1 = currentNode.get(tableName).values().iterator().next();
                            if (tempMap == null) {
                                tempMap = new LinkedHashMap();
                                IMPORT_XML_MAP.put(nodeName, tempMap);
                                index2 = 0;
                            } else {
                                Set sets = tempMap.keySet();
                                index2 = 0;
                                for (String set : sets) {
                                    String firstInd = set.split(",")[0];
                                    if (!firstInd.equals(index1 + "")) continue;
                                    ++index2;
                                }
                            }
                            tempMap.put(index1 + "," + index2, val);
                        } else {
                            list = (List)IMPORT_XML_MAP.get(nodeName);
                            list.add(val);
                        }
                    } else {
                        list = new ArrayList<String>();
                        list.add(val);
                        IMPORT_XML_MAP.put(nodeName, list);
                    }
                }
            } else if (nodeCount == 0) {
                // empty if block
            }
        }
    }

    public static String getMultipleTableFieldName(String name) {
        String val = ValidationCacher.XPATH_TO_FIELD.get(name);
        return val;
    }

    public static void initImportDoc(String importFile) {
        try {
            importXmlDoc = FormCacher.getDocument(importFile);
        }
        catch (Exception e) {
            LOG.error("Error in importXml()", e);
        }
    }

    public void importXml(WebEngine itrEngine, String importFile) {
        long time1 = System.currentTimeMillis();
        try {
            String rootName;
            int index;
            isImportMultiple = FormConfigUtil.importMultiple(MainController.itrName, MainController.asstYear, MainController.version);
            if (importXmlDoc == null) {
                importXmlDoc = FormCacher.getDocument(importFile);
            }
            if ((index = (rootName = importXmlDoc.getDocumentElement().getNodeName()).indexOf(":")) != -1) {
                rootName = rootName.substring(index + 1);
            }
            LOG.info("rootName: " + rootName);
            isRootForm = "Form".equalsIgnoreCase(rootName);
            currentNode.clear();
            IMPORT_KEY_VAL_MAP.clear();
            FormUtil.iterateNodeImportXml(importXmlDoc, "", "");
            LOG.info("IMPORT_KEY_VAL_MAP: " + IMPORT_KEY_VAL_MAP);
            FormUtil.putValuesToHTML(itrEngine);
        }
        catch (Exception e) {
            LOG.error("Error in importXml()", e);
        }
        long time2 = System.currentTimeMillis();
        LOG.info("time taken in importxml function: " + (time2 - time1));
    }

    public void setHtmlElements(HTMLTableElement tableElements, Document doc) throws Exception {
        NodeList inputList = tableElements.getElementsByTagName("input");
        this.setNode(inputList, doc);
        NodeList selectList = tableElements.getElementsByTagName("select");
        this.setNode(selectList, doc);
        NodeList textAreaList = tableElements.getElementsByTagName("textarea");
        this.setNode(textAreaList, doc);
    }

    public void setNode(NodeList nodes, Document doc) throws Exception {
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            HTMLElement inputElement;
            NodeList nodeList;
            Node item = nodes.item(i);
            Node attr = item.getAttributes().getNamedItem("name");
            if (attr == null) continue;
            String name = attr.getNodeValue();
            String xpathString = "";
            xpathString = FormUtil.getXpathForTableCell(name);
            if (xpathString == null || (nodeList = (NodeList)FormCacher.xpath.evaluate(xpathString, doc, XPathConstants.NODESET)) == null || nodeList.getLength() == 0) continue;
            String val = nodeList.item(0).getTextContent();
            if (val.matches("^[0-9]{4}(-)[0-9]{2}(-)[0-9]{2}$")) {
                val = val.substring(8) + "/" + val.substring(5, 7) + "/" + val.substring(0, 4);
            }
            if (item instanceof HTMLInputElement) {
                inputElement = (HTMLInputElement)item;
                inputElement.setValue(val);
                continue;
            }
            if (item instanceof HTMLSelectElement) {
                inputElement = (HTMLSelectElement)item;
                inputElement.setValue(val);
                continue;
            }
            if (!(item instanceof HTMLTextAreaElement)) continue;
            inputElement = (HTMLTextAreaElement)item;
            inputElement.setValue(val);
        }
    }

    public static void wirteToFile(File outputFile, Document doc) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(outputFile);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    public static void writeHtmlToFile(File outputFile, Document doc) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult result = new StreamResult(outputFile);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    public static InputStream getResourceURL(String path) {
        return FormUtil.class.getResourceAsStream(path);
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String getFORMName() {
        String itrName = null;
        try {
            itrName = (String)FormCacher.xpath.evaluate("//Form:FormName", FormCacher.document, XPathConstants.STRING);
            if (itrName == null || itrName.length() == 0) {
                itrName = (String)FormCacher.xpath.evaluate("//Form:FormName|//form10b:FormName|//form6b:FormName|//form10bb:FormName", FormCacher.document, XPathConstants.STRING);
            }
        }
        catch (Exception e) {
            LOG.error("Error in getFORMName()", e);
        }
        return itrName;
    }

    public String getAsstYear() {
        String asstYear = null;
        try {
            asstYear = (String)FormCacher.xpath.evaluate("//Form:AssessmentYear", FormCacher.document, XPathConstants.STRING);
            if (asstYear == null || asstYear != null && asstYear.length() == 0) {
                asstYear = (String)FormCacher.xpath.evaluate("//Form:AssessmentYear|//form10b:AssessmentYear|//form6b:AssessmentYear|//form10bb:AssessmentYear", FormCacher.document, XPathConstants.STRING);
            }
            asstYear = asstYear + "-" + (Integer.parseInt(asstYear) + 1 + "").substring(2);
        }
        catch (Exception e) {
            LOG.error("Error in getAsstYear()", e);
            asstYear = null;
        }
        return asstYear;
    }

    public static String getPAN() {
        String value = null;
        try {
            value = (String)FormCacher.xpath.evaluate("//Form:PAN", FormCacher.document, XPathConstants.STRING);
            if (ValidationUtil.isStringEmpty(value)) {
                value = (String)FormCacher.xpath.evaluate("//Form:PAN", FormCacher.document, XPathConstants.STRING);
            }
        }
        catch (Exception e) {
            LOG.error("Error in getPAN", e);
        }
        return value;
    }

    public static String getVerificationPAN() {
        String value = null;
        try {
            value = (String)FormCacher.xpath.evaluate("//Form:AssesseeVerPAN", FormCacher.document, XPathConstants.STRING);
            if (ValidationUtil.isStringEmpty(value)) {
                value = (String)FormCacher.xpath.evaluate("//Form:AssesseeVerPAN", FormCacher.document, XPathConstants.STRING);
            }
        }
        catch (Exception e) {
            LOG.error("Error in getVerificationPAN", e);
        }
        return value;
    }

    public static String getDOB() {
        String value = null;
        try {
            value = (String)FormCacher.xpath.evaluate("//Form:DOB", FormCacher.document, XPathConstants.STRING);
            if (ValidationUtil.isStringEmpty(value)) {
                value = (String)FormCacher.xpath.evaluate("//Form:DateOFFormOrIncorp", FormCacher.document, XPathConstants.STRING);
            }
            value = value.substring(8) + "/" + value.substring(5, 7) + "/" + value.substring(0, 4);
        }
        catch (Exception e) {
            LOG.error("Error in getDOB", e);
        }
        return value;
    }

    public static void addTableDoc(String name, Document doc) {
        String xpathStr = "";
        xpathStr = FormUtil.getXpathForTableCell(name);
        if (xpathStr == null) {
            return;
        }
        String name1 = xpathStr.substring(0, xpathStr.lastIndexOf("]") + 1);
        if (tempList.contains(name1)) {
            return;
        }
        int index = Integer.parseInt(name.substring(name.lastIndexOf("[") + 1, name.lastIndexOf("]")));
        while (FIELD_VALUE.containsKey(name = name.substring(0, name.lastIndexOf(91) + 1) + ++index + name.substring(name.lastIndexOf(93)))) {
            FormUtil.modifyXmlDoc(name, doc);
        }
    }

    public static void modifyXmlDoc(String name, Document doc) {
        try {
            String xpathStr = "";
            xpathStr = FormUtil.getXpathForTableCell(name);
            NodeList currList = (NodeList)FormCacher.xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
            String tempName = xpathStr.substring(0, xpathStr.lastIndexOf("]") + 1);
            tempList.add(tempName);
            if (currList.getLength() != 0) {
                return;
            }
            String name1 = xpathStr.substring(0, xpathStr.lastIndexOf("["));
            NodeList nodeList = null;
            nodeList = (NodeList)FormCacher.xpath.evaluate(name1, doc, XPathConstants.NODESET);
            int nodeLength = nodeList.getLength();
            Node nextSib = nodeList.item(nodeLength - 1).getNextSibling();
            Node zeroNode = nodeList.item(0);
            Node n = zeroNode.cloneNode(true);
            FormUtil.changeNodeAttr(n, name);
            if (nextSib != null) {
                zeroNode.getParentNode().insertBefore(n, nextSib);
            } else {
                zeroNode.getParentNode().appendChild(n);
            }
        }
        catch (Exception e) {
            LOG.error("Error in modifyXmlDoc()", e);
            LOG.error("Exception modify xmldoc : " + name);
        }
    }

    public static void changeNodeAttr(Node node, String indexAttr) {
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                if (nodeTemp.getNodeType() != 3) {
                    FormUtil.changeNodeAttr(nodeTemp, indexAttr);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null && node.getNodeType() == 1) {
            Element element = (Element)node;
            int len = node.getChildNodes().getLength();
            String attr = element.getAttribute("name");
            if (attr != null && attr.length() != 0) {
                if (len == 0) {
                    node.setTextContent("");
                } else if (len == 1) {
                    node.setNodeValue("");
                }
                element.setAttribute("name", FormUtil.getAttr(attr, indexAttr));
            }
        }
    }

    public static String getAttr(String currAttr, String actAttr) {
        LOG.debug("getAttr starts with defaultAttr:" + currAttr + ",actAttr:" + actAttr);
        String[] actAttrArr = actAttr.split("\\[");
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (String val : actAttrArr) {
            int indexOfRB = val.indexOf("]");
            if (indexOfRB == -1) continue;
            indexList.add(Integer.parseInt(val.substring(0, indexOfRB)));
        }
        LOG.debug("indexList:" + indexList);
        String[] currAttrArr = currAttr.split("\\[");
        String retStr = "";
        int actIndex = 0;
        int size = indexList.size();
        int count = 0;
        for (int i = 0; i < currAttrArr.length; ++i) {
            String temp = currAttrArr[i];
            int brIndex = temp.indexOf("]");
            actIndex = count < size ? (Integer)indexList.get(count) : 0;
            if (brIndex != -1) {
                temp = "[" + actIndex + "]" + temp.substring(brIndex + 1);
                ++count;
            }
            retStr = retStr + temp;
        }
        LOG.debug("getAttr ends with retStr:" + retStr);
        return retStr;
    }

    protected Void call() {
        long time1 = 0L;
        long time2 = 0L;
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    mainController.getVaidationBar().setProgress(-1.0);
                }
            });
            time1 = System.currentTimeMillis();
            this.generateXmlModified();
            LOG.info("outputfilePath" + outputfilePath + ",generateXmlFlag: " + this.generateXmlFlag);
            FormUtil.deleteEmptyNodes(true);
            if (this.generateXmlFlag) {
                this.schemaError = FormCacher.schemeValidate(outputfilePath, this.itrName, this.asstYear, this.ver);
                for (String s : this.schemaError) {
                    LOG.warn(s);
                }
                LOG.info("done with schema error; " + this.schemaError.size());
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MainController.generateXmlFile = new File(outputfilePath);
                        for (int i = 0; i < FormUtil.this.schemaError.size(); ++i) {
                            String error = FormUtil.this.schemaError.get(i);
                            try {
                                error = error.replaceAll("\"", "'");
                                MainController.formErrEngine.executeScript("addErrors('schema.error" + i + "',\"" + error + "\");");
                                continue;
                            }
                            catch (Exception e) {
                                LOG.error("Error in call() ", e);
                                LOG.error("addint schemaError error: " + i + " " + error);
                            }
                        }
                        if (FormUtil.mainController.submitItrFlag && !FormConfigUtil.isCaFlag(FormUtil.this.itrName, FormUtil.this.asstYear, FormUtil.this.isCaFlag)) {
                            FormUtil.mainController.submitItrFlag = false;
                            mainController.getVaidationBar().setProgress(1.0);
                            mainController.OpenSubmitDialog();
                        }
                    }
                });
            }
        }
        catch (ConcurrentModificationException e) {
            LOG.error("error in call", e);
        }
        catch (Exception e) {
            LOG.error("error in call", e);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("itr.xml.generate.error"), true);
                }
            });
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                mainController.getVaidationBar().setProgress(1.0);
            }
        });
        time2 = System.currentTimeMillis();
        LOG.info("Time taken to generate: " + (time2 - time1));
        return null;
    }

    public static void deleteEmptyNodes(boolean flag) {
        try {
            File outPutFile = new File(outputfilePath);
            if (outPutFile.exists()) {
                Document doc = FormCacher.getDocument(outPutFile.getAbsolutePath());
                FormUtil.deleteZeroNodesMain(doc);
                if (flag) {
                    FormUtil.deleteNodes(doc);
                    FormUtil.deleteNodeGenerateXml(doc);
                }
                FormUtil.wirteToFile(outPutFile, doc);
            }
        }
        catch (Exception e) {
            LOG.error("Error in deleteEmptyNodes()", e);
        }
    }

    public static void deleteNodeGenerateXml(Document doc) {
        if (!FormConfigUtil.DELETE_NODE_GENERATE_XML.isEmpty()) {
            for (String node : FormConfigUtil.DELETE_NODE_GENERATE_XML) {
                NodeList nodeList = doc.getElementsByTagNameNS("*", node);
                int nodeLength = nodeList.getLength();
                while (nodeLength != 0) {
                    Node deleteNode = nodeList.item(nodeLength - 1);
                    deleteNode.getParentNode().removeChild(deleteNode);
                    nodeLength = nodeList.getLength();
                }
            }
        }
    }

    public static void deleteZeroNodesMain(Document doc) {
        Set<String> keySet = ValidationCacher.DELETE_ZERO_NODES.keySet();
        String val = null;
        for (String key : keySet) {
            if (key.contains("-")) continue;
            try {
                val = ValidationCacher.DELETE_ZERO_NODES.get(key);
                NodeList nodes = (NodeList)FormCacher.xpath.evaluate(val, doc, XPathConstants.NODESET);
                int nodeLength = nodes.getLength();
                if (nodeLength == 0) continue;
                for (int i = 0; i < nodeLength; ++i) {
                    Node node = nodes.item(i);
                    nodeValZeroCount = 0;
                    nodeValNonZeroCount = 0;
                    FormUtil.deleteZeroNodes(node);
                    if (nodeValZeroCount != nodeValNonZeroCount) continue;
                    node.getParentNode().removeChild(node);
                }
            }
            catch (Exception e) {
                LOG.error("Error in deleteZeroNodesMain()", e);
                LOG.error("Not able to delete node: " + val);
            }
        }
    }

    public static void deleteNodes(Node node) {
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                if (nodeTemp.getNodeType() != 3) {
                    FormUtil.deleteNodes(nodeTemp);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null) {
            Element element;
            if (node.getNodeType() == 1 && (element = (Element)node).getAttribute("name") != null) {
                element.removeAttribute("name");
            }
            if (node.getParentNode() != null && node.getTextContent().trim().length() == 0) {
                node.getParentNode().removeChild(node);
            }
        }
    }

    public static void removeAttr(Node node) {
        Element element;
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                if (nodeTemp.getNodeType() != 3) {
                    FormUtil.removeAttr(nodeTemp);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null && node.getNodeType() == 1 && (element = (Element)node).getAttribute("name") != null) {
            element.removeAttribute("name");
        }
    }

    public static void deleteZeroNodes(Node node) {
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                if (nodeTemp.getNodeType() != 3) {
                    FormUtil.deleteZeroNodes(nodeTemp);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null && node.getParentNode() != null) {
            String val = node.getTextContent().trim();
            if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1) {
                String name = node.getNodeName();
                if (name.contains(":")) {
                    name = name.substring(name.lastIndexOf(":") + 1);
                }
                if (!ValidationCacher.DELETE_ZERO_NODES.containsValue(name)) {
                    ++nodeValNonZeroCount;
                    if (val.length() == 0 || val.equals("0") || val.equals("0.0")) {
                        ++nodeValZeroCount;
                    }
                }
            }
        }
    }

    public static boolean isConnected() {
        boolean connected = false;
        try {
            URL url = new URL("https://incometaxindiaefiling.gov.in/e-Filing/UserLogin/Login.html");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.connect();
            conn.disconnect();
            connected = true;
        }
        catch (IOException ex) {
            Logger.getLogger(FormUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return connected;
    }

    public static String getOutputfilePath() {
        return outputfilePath;
    }

    public static void setOutputfilePath(String outputfilePath) {
        FormUtil.outputfilePath = outputfilePath;
    }

    public MainController getMainController() {
        return mainController;
    }

    public void setMainController(MainController mainController) {
        FormUtil.mainController = mainController;
    }

    public boolean isSchemaValidationFlag() {
        return this.schemaValidationFlag;
    }

    public void setSchemaValidationFlag(boolean schemaValidationFlag) {
        this.schemaValidationFlag = schemaValidationFlag;
    }

    public String getItrName() {
        return this.itrName;
    }

    public void setItrName(String itrName) {
        this.itrName = itrName;
    }

    public String getVer() {
        return this.ver;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    public boolean isIsSchemaFlag() {
        return this.isSchemaFlag;
    }

    public void setIsSchemaFlag(boolean isSchemaFlag) {
        this.isSchemaFlag = isSchemaFlag;
    }

    public void setAsstYear(String asstYear) {
        this.asstYear = asstYear;
    }

    public boolean isGenerateXmlFlag() {
        return this.generateXmlFlag;
    }

    public void setGenerateXmlFlag(boolean generateXmlFlag) {
        this.generateXmlFlag = generateXmlFlag;
    }

    public String getBaseFieldName(String name) {
        return name.replaceAll("\\[[0-9]*\\]", "[0]");
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public static Document getXmlDoc() {
        return xmlDoc;
    }

    public static void setXmlDoc(Document xmlDoc) {
        FormUtil.xmlDoc = xmlDoc;
    }

    public static Document getImportXmlDoc() {
        return importXmlDoc;
    }

    public static void setImportXmlDoc(Document importXmlDoc) {
        FormUtil.importXmlDoc = importXmlDoc;
    }

    static {
        IMPORT_XML_MAP = new HashMap<String, Object>();
        HTML_FIELD_MAP = new HashMap<String, String>();
        count2 = 0;
        noset = 0;
        issaveDraft = false;
        nodeIndexCount = 0;
        IMPORT_KEY_VAL_MAP = new LinkedHashMap<String, Map<String, String>>();
        IMPORT_HTML_FIELD_VALUE = new LinkedHashMap<String, List<String>>();
        tableNodes = new HashMap<String, Integer>();
        currentNode = new HashMap<String, Map<String, Integer>>();
        index2 = 0;
        importXmlDoc = null;
        TIMESTAMP_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        tempList = new ArrayList<String>();
    }
}

